/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.runtime.app;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.onosproject.yang.YangModel;
import org.onosproject.yang.YangModuleId;
import org.onosproject.yang.runtime.api.AppModuleInfo;
import org.onosproject.yang.runtime.api.ModelRegistrationParam;

public class DefaultModelRegistrationParam
implements ModelRegistrationParam {
    private YangModel model;
    private final Map<YangModuleId, AppModuleInfo> appInfoMap = new LinkedHashMap<YangModuleId, AppModuleInfo>();

    public YangModel getYangModel() {
        return this.model;
    }

    public void setYangModel(YangModel model) {
        Preconditions.checkNotNull((Object)model);
        this.model = model;
    }

    public AppModuleInfo getAppModuleInfo(YangModuleId id) {
        return this.appInfoMap.get(id);
    }

    public void addAppModuleInfo(YangModuleId id, AppModuleInfo info) {
        this.appInfoMap.put(id, info);
    }

    public int hashCode() {
        return Objects.hash(this.appInfoMap, this.model);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        DefaultModelRegistrationParam that = (DefaultModelRegistrationParam)obj;
        if (this.appInfoMap.size() == that.appInfoMap.size()) {
            for (Map.Entry<YangModuleId, AppModuleInfo> entry : this.appInfoMap.entrySet()) {
                if (that.appInfoMap.containsKey(entry.getKey()) && that.appInfoMap.containsValue(entry.getValue())) continue;
                return false;
            }
            return Objects.equals(this.model, that.model);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("model", (Object)this.model).add("appInfo", this.appInfoMap).toString();
    }
}

