/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.runtime.app;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.onosproject.yang.YangModel;
import org.onosproject.yang.YangModuleId;
import org.onosproject.yang.compiler.datamodel.YangNode;
import org.onosproject.yang.compiler.datamodel.YangSchemaNode;
import org.onosproject.yang.compiler.datamodel.exceptions.DataModelException;
import org.onosproject.yang.compiler.plugin.utils.YangApacheUtils;
import org.onosproject.yang.runtime.api.AppModuleInfo;
import org.onosproject.yang.runtime.api.ModelRegistrationParam;
import org.onosproject.yang.runtime.api.YangModelRegistry;
import org.onosproject.yang.runtime.utils.RuntimeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultYangModelRegistry
implements YangModelRegistry {
    private static final Logger log = LoggerFactory.getLogger(DefaultYangModelRegistry.class);
    private static final String AT = "@";
    private final ConcurrentMap<String, ConcurrentMap<String, YangSchemaNode>> yangSchemaStore;
    private final ConcurrentMap<String, YangSchemaNode> interfaceNameKeyStore;
    private final ConcurrentMap<String, YangSchemaNode> opParamNameKeyStore;
    private final ConcurrentMap<String, YangSchemaNode> appNameKeyStore;
    private final ConcurrentMap<String, Class<?>> registerClassStore;
    private final ConcurrentMap<String, YangSchemaNode> nameSpaceSchemaStore;
    private final Set<YangModel> models = new LinkedHashSet<YangModel>();

    public DefaultYangModelRegistry() {
        this.yangSchemaStore = new ConcurrentHashMap<String, ConcurrentMap<String, YangSchemaNode>>();
        this.interfaceNameKeyStore = new ConcurrentHashMap<String, YangSchemaNode>();
        this.opParamNameKeyStore = new ConcurrentHashMap<String, YangSchemaNode>();
        this.registerClassStore = new ConcurrentHashMap();
        this.appNameKeyStore = new ConcurrentHashMap<String, YangSchemaNode>();
        this.nameSpaceSchemaStore = new ConcurrentHashMap<String, YangSchemaNode>();
    }

    public void registerModel(ModelRegistrationParam param) {
        YangModel model = param.getYangModel();
        if (model != null) {
            Set curNodes = RuntimeHelper.getNodes((YangModel)model);
            this.models.add(model);
            for (YangModuleId id : model.getYangModulesId()) {
                AppModuleInfo info = param.getAppModuleInfo(id);
                if (info == null) continue;
                Class service = info.getModuleClass();
                String name = service.getName();
                if (this.verifyIfApplicationAlreadyRegistered(service)) continue;
                if (!this.registerClassStore.containsKey(name)) {
                    this.registerClassStore.put(name, service);
                }
                if (curNodes == null || curNodes.isEmpty()) continue;
                this.processRegistration(service, curNodes);
            }
        } else {
            throw new RuntimeException("model can not be null.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterModel(ModelRegistrationParam param) {
        Class<DefaultYangModelRegistry> clazz = DefaultYangModelRegistry.class;
        synchronized (DefaultYangModelRegistry.class) {
            YangModel model = param.getYangModel();
            if (model != null) {
                for (YangModuleId id : model.getYangModulesId()) {
                    AppModuleInfo info = param.getAppModuleInfo(id);
                    Class sClass = info.getModuleClass();
                    String serviceName = sClass.getName();
                    this.registerClassStore.remove(serviceName);
                    YangSchemaNode curNode = (YangSchemaNode)this.appNameKeyStore.get(serviceName);
                    if (curNode == null) {
                        curNode = (YangSchemaNode)this.interfaceNameKeyStore.get(serviceName);
                    }
                    if (curNode != null) {
                        this.removeSchemaNode(curNode);
                        this.interfaceNameKeyStore.remove(RuntimeHelper.getInterfaceClassName((YangSchemaNode)curNode));
                        this.opParamNameKeyStore.remove(RuntimeHelper.getOpParamClassName((YangSchemaNode)curNode));
                        this.appNameKeyStore.remove(serviceName);
                        this.nameSpaceSchemaStore.remove(curNode.getNameSpace().getModuleNamespace());
                        log.info(" service class {} of model {} is unregistered.", (Object)sClass.getSimpleName(), (Object)param);
                        continue;
                    }
                    throw new RuntimeException(sClass.getSimpleName() + " service was not registered.");
                }
            } else {
                throw new RuntimeException("model can not be null.");
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public Set<YangModel> getModels() {
        return this.models;
    }

    public YangSchemaNode getForSchemaName(String schemaName) {
        return this.getForNameWithRev(schemaName);
    }

    public YangSchemaNode getForAppName(String appName) {
        YangSchemaNode node = (YangSchemaNode)this.appNameKeyStore.get(appName);
        if (node == null) {
            log.error("{} not found.", (Object)appName);
        }
        return node;
    }

    public YangSchemaNode getForInterfaceFileName(String name) {
        YangSchemaNode node = (YangSchemaNode)this.interfaceNameKeyStore.get(name);
        if (node == null) {
            log.error("{} not found.", (Object)name);
        }
        return node;
    }

    public YangSchemaNode getForOpPramFileName(String name) {
        YangSchemaNode node = (YangSchemaNode)this.opParamNameKeyStore.get(name);
        if (node == null) {
            log.error("{} not found.", (Object)name);
        }
        return node;
    }

    public YangSchemaNode getForNameSpace(String nameSpace) {
        YangSchemaNode node = (YangSchemaNode)this.nameSpaceSchemaStore.get(nameSpace);
        if (node == null) {
            log.error("node with {} namespace not found.", (Object)nameSpace);
        }
        return node;
    }

    public Class<?> getRegisteredClass(YangSchemaNode schemaNode) {
        String interfaceName = RuntimeHelper.getInterfaceClassName((YangSchemaNode)schemaNode);
        String serviceName = RuntimeHelper.getServiceName((YangSchemaNode)schemaNode);
        Class regClass = (Class)this.registerClassStore.get(serviceName);
        if (regClass == null) {
            regClass = (Class)this.registerClassStore.get(interfaceName);
        }
        return regClass;
    }

    private void processRegistration(Class<?> service, Set<YangNode> nodes) {
        YangNode schemaNode = this.findNodeWhichShouldBeReg(service.getName(), nodes);
        if (schemaNode != null) {
            this.processApplicationContext((YangSchemaNode)schemaNode, service.getName());
        }
    }

    private YangNode findNodeWhichShouldBeReg(String name, Set<YangNode> nodes) {
        for (YangNode node : nodes) {
            if (!name.equals(RuntimeHelper.getServiceName((YangSchemaNode)node)) && !name.equals(RuntimeHelper.getInterfaceClassName((YangSchemaNode)node))) continue;
            return node;
        }
        return null;
    }

    private boolean verifyIfApplicationAlreadyRegistered(Class<?> appClass) {
        String appName = appClass.getName();
        return this.registerClassStore.containsKey(appName) || this.interfaceNameKeyStore.containsKey(appName);
    }

    private void processApplicationContext(YangSchemaNode appNode, String name) {
        try {
            if (appNode.isNotificationPresent()) {
                this.appNameKeyStore.put(name, appNode);
            }
        }
        catch (DataModelException e) {
            e.printStackTrace();
        }
        this.addToSchemaStore(appNode);
        this.interfaceNameKeyStore.put(RuntimeHelper.getInterfaceClassName((YangSchemaNode)appNode), appNode);
        this.opParamNameKeyStore.put(RuntimeHelper.getOpParamClassName((YangSchemaNode)appNode), appNode);
        this.nameSpaceSchemaStore.put(appNode.getNameSpace().getModuleNamespace(), appNode);
        log.info("successfully registered this application {}", (Object)name);
    }

    private YangSchemaNode getForNameWithRev(String name) {
        ConcurrentMap revMap;
        if (name.contains(AT)) {
            String[] revArray = name.split(AT);
            ConcurrentMap revMap2 = (ConcurrentMap)this.yangSchemaStore.get(revArray[0]);
            YangSchemaNode schemaNode = (YangSchemaNode)revMap2.get(name);
            if (schemaNode == null) {
                log.error("{} not found.", (Object)name);
            }
            return schemaNode;
        }
        if (this.yangSchemaStore.containsKey(name) && (revMap = (ConcurrentMap)this.yangSchemaStore.get(name)) != null && !revMap.isEmpty()) {
            YangSchemaNode node = (YangSchemaNode)revMap.get(name);
            if (node != null) {
                return node;
            }
            String revName = this.getLatestVersion(revMap);
            return (YangSchemaNode)revMap.get(revName);
        }
        log.error("{} not found.", (Object)name);
        return null;
    }

    private String getLatestVersion(ConcurrentMap<String, YangSchemaNode> revMap) {
        ArrayList keys = new ArrayList();
        for (Map.Entry entry : revMap.entrySet()) {
            keys.add(entry.getKey());
        }
        Collections.sort(keys);
        return (String)keys.get(keys.size() - 1);
    }

    private void addToSchemaStore(YangSchemaNode schemaNode) {
        String name;
        String date = YangApacheUtils.getDateInStringFormat((YangNode)((YangNode)schemaNode));
        String revName = name = schemaNode.getName();
        if (date != null) {
            revName = name + AT + date;
        }
        if (!this.yangSchemaStore.containsKey(name)) {
            ConcurrentHashMap<String, YangSchemaNode> revStore = new ConcurrentHashMap<String, YangSchemaNode>();
            revStore.put(revName, schemaNode);
            this.yangSchemaStore.put(name, revStore);
        } else {
            ((ConcurrentMap)this.yangSchemaStore.get(name)).put(revName, schemaNode);
        }
    }

    private void removeSchemaNode(YangSchemaNode removableNode) {
        ConcurrentMap revMap;
        String name;
        String revName = name = removableNode.getName();
        String date = YangApacheUtils.getDateInStringFormat((YangNode)((YangNode)removableNode));
        if (date != null) {
            revName = name + AT + date;
        }
        if ((revMap = (ConcurrentMap)this.yangSchemaStore.get(name)) != null && !revMap.isEmpty() && revMap.size() != 1) {
            revMap.remove(revName);
        } else {
            this.yangSchemaStore.remove(removableNode.getName());
        }
    }
}

