/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.runtime.app;

import org.onosproject.yang.model.SchemaContext;
import org.onosproject.yang.runtime.api.CompositeData;
import org.onosproject.yang.runtime.api.CompositeStream;
import org.onosproject.yang.runtime.api.YangRuntimeException;
import org.onosproject.yang.runtime.api.YangRuntimeService;
import org.onosproject.yang.runtime.api.YangSerializer;
import org.onosproject.yang.runtime.api.YangSerializerContext;
import org.onosproject.yang.runtime.api.YangSerializerRegistry;
import org.onosproject.yang.runtime.app.DefaultYangModelRegistry;
import org.onosproject.yang.runtime.app.DefaultYangSerializerContext;
import org.onosproject.yang.runtime.app.DefaultYangSerializerRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultYangRuntimeHandler
implements YangRuntimeService {
    private static final Logger log = LoggerFactory.getLogger(DefaultYangModelRegistry.class);
    private static final String DF = "Data format ";
    private static final String NR = " is not registered.";
    private YangSerializerRegistry registry;
    private SchemaContext rootContext;
    private YangSerializerContext serializerContext;

    public DefaultYangRuntimeHandler(YangSerializerRegistry r, SchemaContext c) {
        this.registry = r;
        this.rootContext = c;
        this.serializerContext = new DefaultYangSerializerContext(this.rootContext);
    }

    public CompositeData decode(CompositeStream external, String dataFormat) {
        YangSerializer ys = this.getRegisteredSerializer(dataFormat);
        return ys.decode(external, this.serializerContext);
    }

    public CompositeStream encode(CompositeData internal, String dataFormat) {
        YangSerializer ys = this.getRegisteredSerializer(dataFormat);
        return ys.encode(internal, this.serializerContext);
    }

    private YangSerializer getRegisteredSerializer(String df) {
        YangSerializer s = ((DefaultYangSerializerRegistry)this.registry).getSerializer(df);
        if (s == null) {
            log.info("Data format  {}  is not registered.", (Object)df);
            throw new YangRuntimeException(DF + df + NR);
        }
        return s;
    }
}

