/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.runtime.app;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.onosproject.yang.runtime.api.YangSerializer;
import org.onosproject.yang.runtime.api.YangSerializerRegistry;
import org.onosproject.yang.runtime.app.DefaultYangModelRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultYangSerializerRegistry
implements YangSerializerRegistry {
    private static final Logger log = LoggerFactory.getLogger(DefaultYangModelRegistry.class);
    private static final String NOT_REGISTERED = "Serializer is not registered.";
    private final ConcurrentMap<String, YangSerializer> serializerMap = new ConcurrentHashMap<String, YangSerializer>();

    public void registerSerializer(YangSerializer serializer) {
        if (this.serializerMap.containsKey(serializer.supportsFormat())) {
            log.info("Overwriting the registered {} data format.", (Object)serializer.supportsFormat());
        }
        this.serializerMap.put(serializer.supportsFormat(), serializer);
    }

    public void unregisterSerializer(YangSerializer serializer) throws IllegalArgumentException {
        if (!this.serializerMap.remove(serializer.supportsFormat(), serializer)) {
            throw new IllegalArgumentException(NOT_REGISTERED);
        }
    }

    public Set<YangSerializer> getSerializers() {
        return new HashSet<YangSerializer>(this.serializerMap.values());
    }

    public YangSerializer getSerializer(String dataFormat) {
        return (YangSerializer)this.serializerMap.get(dataFormat);
    }
}

