/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.network.rev20151208.yrtietfnetwork.networks;

import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.network.rev20151208.yrtietfnetwork.NetworkId;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.network.rev20151208.yrtietfnetwork.networks
            .network.NetworkTypes;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.network.rev20151208.yrtietfnetwork.networks
            .network.Node;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.network.rev20151208.yrtietfnetwork.networks
            .network.SupportingNetwork;
import org.onosproject.yang.model.ModelObject;

/**
 * Represents the implementation of network.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultNetwork extends ModelObject implements Network {
    protected NetworkId networkId;
    protected BitSet valueLeafFlags = new BitSet();
    protected NetworkTypes networkTypes;
    protected List<SupportingNetwork> supportingNetwork;
    protected List<Node> node;

    @Override
    public NetworkId networkId() {
        return networkId;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public NetworkTypes networkTypes() {
        return networkTypes;
    }

    @Override
    public List<SupportingNetwork> supportingNetwork() {
        return supportingNetwork;
    }

    @Override
    public List<Node> node() {
        return node;
    }

    @Override
    public void networkId(NetworkId networkId) {
        valueLeafFlags.set(LeafIdentifier.NETWORKID.getLeafIndex());
        this.networkId = networkId;
    }

    @Override
    public void networkTypes(NetworkTypes networkTypes) {
        this.networkTypes = networkTypes;
    }

    @Override
    public void supportingNetwork(List<SupportingNetwork> supportingNetwork) {
        this.supportingNetwork = supportingNetwork;
    }

    @Override
    public void node(List<Node> node) {
        this.node = node;
    }

    @Override
    public int hashCode() {
        return Objects.hash(networkId, valueLeafFlags, networkTypes, supportingNetwork, node);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultNetwork) {
            DefaultNetwork other = (DefaultNetwork) obj;
            return
                Objects.equals(networkId, other.networkId) &&
                Objects.equals(valueLeafFlags, other.valueLeafFlags) &&
                Objects.equals(networkTypes, other.networkTypes) &&
                Objects.equals(supportingNetwork, other.supportingNetwork) &&
                Objects.equals(node, other.node);
        }
        return false;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(getClass())
            .omitNullValues()
            .add("networkId", networkId)
            .add("valueLeafFlags", valueLeafFlags)
            .add("networkTypes", networkTypes)
            .add("supportingNetwork", supportingNetwork)
            .add("node", node)
            .toString();
    }


    /**
     * Creates an instance of defaultNetwork.
     */
    public DefaultNetwork() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}
