/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.network.topology.rev20151208
            .yrtnetworktopology.networks.network.augmentedndnetwork;

import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.network.topology.rev20151208
            .yrtnetworktopology.LinkId;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.network.topology.rev20151208
            .yrtnetworktopology.networks.network.augmentedndnetwork.link.Destination;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.network.topology.rev20151208
            .yrtnetworktopology.networks.network.augmentedndnetwork.link.Source;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.network.topology.rev20151208
            .yrtnetworktopology.networks.network.augmentedndnetwork.link.SupportingLink;
import org.onosproject.yang.model.ModelObject;

/**
 * Represents the implementation of link.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultLink extends ModelObject implements Link {
    protected LinkId linkId;
    protected BitSet valueLeafFlags = new BitSet();
    protected Source source;
    protected Destination destination;
    protected List<SupportingLink> supportingLink;

    @Override
    public LinkId linkId() {
        return linkId;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public Source source() {
        return source;
    }

    @Override
    public Destination destination() {
        return destination;
    }

    @Override
    public List<SupportingLink> supportingLink() {
        return supportingLink;
    }

    @Override
    public void linkId(LinkId linkId) {
        valueLeafFlags.set(LeafIdentifier.LINKID.getLeafIndex());
        this.linkId = linkId;
    }

    @Override
    public void source(Source source) {
        this.source = source;
    }

    @Override
    public void destination(Destination destination) {
        this.destination = destination;
    }

    @Override
    public void supportingLink(List<SupportingLink> supportingLink) {
        this.supportingLink = supportingLink;
    }

    @Override
    public int hashCode() {
        return Objects.hash(linkId, valueLeafFlags, source, destination, supportingLink);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultLink) {
            DefaultLink other = (DefaultLink) obj;
            return
                Objects.equals(linkId, other.linkId) &&
                Objects.equals(valueLeafFlags, other.valueLeafFlags) &&
                Objects.equals(source, other.source) &&
                Objects.equals(destination, other.destination) &&
                Objects.equals(supportingLink, other.supportingLink);
        }
        return false;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(getClass())
            .omitNullValues()
            .add("linkId", linkId)
            .add("valueLeafFlags", valueLeafFlags)
            .add("source", source)
            .add("destination", destination)
            .add("supportingLink", supportingLink)
            .toString();
    }


    /**
     * Creates an instance of defaultLink.
     */
    public DefaultLink() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}
