/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.network.topology.rev20151208
            .yrtnetworktopology.networks.network.augmentedndnetwork.link;

import com.google.common.base.MoreObjects;
import java.util.BitSet;
import java.util.Objects;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.network.rev20151208.yrtietfnetwork.NetworkId;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.network.topology.rev20151208
            .yrtnetworktopology.LinkId;
import org.onosproject.yang.model.ModelObject;

/**
 * Represents the implementation of supportingLink.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultSupportingLink extends ModelObject implements SupportingLink {
    protected NetworkId networkRef;
    protected LinkId linkRef;
    protected BitSet valueLeafFlags = new BitSet();

    @Override
    public NetworkId networkRef() {
        return networkRef;
    }

    @Override
    public LinkId linkRef() {
        return linkRef;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public void networkRef(NetworkId networkRef) {
        valueLeafFlags.set(LeafIdentifier.NETWORKREF.getLeafIndex());
        this.networkRef = networkRef;
    }

    @Override
    public void linkRef(LinkId linkRef) {
        valueLeafFlags.set(LeafIdentifier.LINKREF.getLeafIndex());
        this.linkRef = linkRef;
    }

    @Override
    public int hashCode() {
        return Objects.hash(networkRef, linkRef, valueLeafFlags);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultSupportingLink) {
            DefaultSupportingLink other = (DefaultSupportingLink) obj;
            return
                Objects.equals(networkRef, other.networkRef) &&
                Objects.equals(linkRef, other.linkRef) &&
                Objects.equals(valueLeafFlags, other.valueLeafFlags);
        }
        return false;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(getClass())
            .omitNullValues()
            .add("networkRef", networkRef)
            .add("linkRef", linkRef)
            .add("valueLeafFlags", valueLeafFlags)
            .toString();
    }


    /**
     * Creates an instance of defaultSupportingLink.
     */
    public DefaultSupportingLink() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}
