/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.network.topology.rev20151208
            .yrtnetworktopology.networks.network.node.augmentedndnode.tpoint;

import com.google.common.base.MoreObjects;
import java.util.BitSet;
import java.util.Objects;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.network.rev20151208.yrtietfnetwork.NetworkId;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.network.rev20151208.yrtietfnetwork.NodeId;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.network.topology.rev20151208
            .yrtnetworktopology.TpId;
import org.onosproject.yang.model.ModelObject;

/**
 * Represents the implementation of supportingTerminationPoint.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultSupportingTerminationPoint extends ModelObject implements SupportingTerminationPoint {
    protected NetworkId networkRef;
    protected NodeId nodeRef;
    protected TpId tpRef;
    protected BitSet valueLeafFlags = new BitSet();

    @Override
    public NetworkId networkRef() {
        return networkRef;
    }

    @Override
    public NodeId nodeRef() {
        return nodeRef;
    }

    @Override
    public TpId tpRef() {
        return tpRef;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public void networkRef(NetworkId networkRef) {
        valueLeafFlags.set(LeafIdentifier.NETWORKREF.getLeafIndex());
        this.networkRef = networkRef;
    }

    @Override
    public void nodeRef(NodeId nodeRef) {
        valueLeafFlags.set(LeafIdentifier.NODEREF.getLeafIndex());
        this.nodeRef = nodeRef;
    }

    @Override
    public void tpRef(TpId tpRef) {
        valueLeafFlags.set(LeafIdentifier.TPREF.getLeafIndex());
        this.tpRef = tpRef;
    }

    @Override
    public int hashCode() {
        return Objects.hash(networkRef, nodeRef, tpRef, valueLeafFlags);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultSupportingTerminationPoint) {
            DefaultSupportingTerminationPoint other = (DefaultSupportingTerminationPoint) obj;
            return
                Objects.equals(networkRef, other.networkRef) &&
                Objects.equals(nodeRef, other.nodeRef) &&
                Objects.equals(tpRef, other.tpRef) &&
                Objects.equals(valueLeafFlags, other.valueLeafFlags);
        }
        return false;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(getClass())
            .omitNullValues()
            .add("networkRef", networkRef)
            .add("nodeRef", nodeRef)
            .add("tpRef", tpRef)
            .add("valueLeafFlags", valueLeafFlags)
            .toString();
    }


    /**
     * Creates an instance of defaultSupportingTerminationPoint.
     */
    public DefaultSupportingTerminationPoint() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}
