/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.schedule.rev20160301.yrtietfschedule
            .schedules.schedules;

import java.util.BitSet;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.yang.types.rev20130715.yrtietfyangtypes
            .DateAndTime;

/**
 * Abstraction of an entity which represents the functionality of schedule.
 */
public interface Schedule {

    /**
     * Identify the leaf of Schedule.
     */
    public enum LeafIdentifier {
        /**
         * Represents scheduleId.
         */
        SCHEDULEID(1),
        /**
         * Represents start.
         */
        START(2),
        /**
         * Represents scheduleDuration.
         */
        SCHEDULEDURATION(3),
        /**
         * Represents repeatInterval.
         */
        REPEATINTERVAL(4);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute scheduleId.
     *
     * @return scheduleId value of scheduleId
     */
    long scheduleId();

    /**
     * Returns the attribute start.
     *
     * @return start value of start
     */
    DateAndTime start();

    /**
     * Returns the attribute scheduleDuration.
     *
     * @return scheduleDuration value of scheduleDuration
     */
    String scheduleDuration();

    /**
     * Returns the attribute repeatInterval.
     *
     * @return repeatInterval value of repeatInterval
     */
    String repeatInterval();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Sets the attribute scheduleId.
     *
     * @param scheduleId value of scheduleId
     */
    void scheduleId(long scheduleId);

    /**
     * Sets the attribute start.
     *
     * @param start value of start
     */
    void start(DateAndTime start);

    /**
     * Sets the attribute scheduleDuration.
     *
     * @param scheduleDuration value of scheduleDuration
     */
    void scheduleDuration(String scheduleDuration);

    /**
     * Sets the attribute repeatInterval.
     *
     * @param repeatInterval value of repeatInterval
     */
    void repeatInterval(String repeatInterval);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}
