/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology;

import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .informationsourceattributes.InformationSourceEnum;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .informationsourceattributes.InformationSourceState;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .tenodeconfigattributesnotification.TeNodeAttributes;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .tenodestatederivednotification.AltInformationSources;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .tetopologytype.TeTopology;
import org.onosproject.yang.model.ModelObject;

/**
 * Represents the implementation of teNodeEvent.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultTeNodeEvent extends ModelObject implements TeNodeEvent {
    protected TeTopologyEventType eventType;
    protected Object nodeRef;
    protected Object networkRef;
    protected TeOperStatus operStatus;
    protected boolean isMultiAccessDr;
    protected InformationSourceEnum informationSource;
    protected BitSet valueLeafFlags = new BitSet();
    protected TeTopology teTopology;
    protected TeNodeAttributes teNodeAttributes;
    protected List<AltInformationSources> altInformationSources;
    protected InformationSourceState informationSourceState;

    @Override
    public TeTopologyEventType eventType() {
        return eventType;
    }

    @Override
    public Object nodeRef() {
        return nodeRef;
    }

    @Override
    public Object networkRef() {
        return networkRef;
    }

    @Override
    public TeOperStatus operStatus() {
        return operStatus;
    }

    @Override
    public boolean isMultiAccessDr() {
        return isMultiAccessDr;
    }

    @Override
    public InformationSourceEnum informationSource() {
        return informationSource;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public TeTopology teTopology() {
        return teTopology;
    }

    @Override
    public TeNodeAttributes teNodeAttributes() {
        return teNodeAttributes;
    }

    @Override
    public List<AltInformationSources> altInformationSources() {
        return altInformationSources;
    }

    @Override
    public InformationSourceState informationSourceState() {
        return informationSourceState;
    }

    @Override
    public void eventType(TeTopologyEventType eventType) {
        valueLeafFlags.set(LeafIdentifier.EVENTTYPE.getLeafIndex());
        this.eventType = eventType;
    }

    @Override
    public void nodeRef(Object nodeRef) {
        valueLeafFlags.set(LeafIdentifier.NODEREF.getLeafIndex());
        this.nodeRef = nodeRef;
    }

    @Override
    public void networkRef(Object networkRef) {
        valueLeafFlags.set(LeafIdentifier.NETWORKREF.getLeafIndex());
        this.networkRef = networkRef;
    }

    @Override
    public void operStatus(TeOperStatus operStatus) {
        valueLeafFlags.set(LeafIdentifier.OPERSTATUS.getLeafIndex());
        this.operStatus = operStatus;
    }

    @Override
    public void isMultiAccessDr(boolean isMultiAccessDr) {
        valueLeafFlags.set(LeafIdentifier.ISMULTIACCESSDR.getLeafIndex());
        this.isMultiAccessDr = isMultiAccessDr;
    }

    @Override
    public void informationSource(InformationSourceEnum informationSource) {
        valueLeafFlags.set(LeafIdentifier.INFORMATIONSOURCE.getLeafIndex());
        this.informationSource = informationSource;
    }

    @Override
    public void teTopology(TeTopology teTopology) {
        this.teTopology = teTopology;
    }

    @Override
    public void teNodeAttributes(TeNodeAttributes teNodeAttributes) {
        this.teNodeAttributes = teNodeAttributes;
    }

    @Override
    public void altInformationSources(List<AltInformationSources> altInformationSources) {
        this.altInformationSources = altInformationSources;
    }

    @Override
    public void informationSourceState(InformationSourceState informationSourceState) {
        this.informationSourceState = informationSourceState;
    }

    @Override
    public int hashCode() {
         return Objects.hash(eventType, nodeRef, networkRef, operStatus, isMultiAccessDr, informationSource,
                    valueLeafFlags, teTopology, teNodeAttributes, altInformationSources, informationSourceState);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultTeNodeEvent) {
            DefaultTeNodeEvent other = (DefaultTeNodeEvent) obj;
            return
                Objects.equals(eventType, other.eventType) &&
                Objects.equals(nodeRef, other.nodeRef) &&
                Objects.equals(networkRef, other.networkRef) &&
                Objects.equals(operStatus, other.operStatus) &&
                Objects.equals(isMultiAccessDr, other.isMultiAccessDr) &&
                Objects.equals(informationSource, other.informationSource) &&
                Objects.equals(valueLeafFlags, other.valueLeafFlags) &&
                Objects.equals(teTopology, other.teTopology) &&
                Objects.equals(teNodeAttributes, other.teNodeAttributes) &&
                Objects.equals(altInformationSources, other.altInformationSources) &&
                Objects.equals(informationSourceState, other.informationSourceState);
        }
        return false;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(getClass())
            .omitNullValues()
            .add("eventType", eventType)
            .add("nodeRef", nodeRef)
            .add("networkRef", networkRef)
            .add("operStatus", operStatus)
            .add("isMultiAccessDr", isMultiAccessDr)
            .add("informationSource", informationSource)
            .add("valueLeafFlags", valueLeafFlags)
            .add("teTopology", teTopology)
            .add("teNodeAttributes", teNodeAttributes)
            .add("altInformationSources", altInformationSources)
            .add("informationSourceState", informationSourceState)
            .toString();
    }


    /**
     * Creates an instance of defaultTeNodeEvent.
     */
    public DefaultTeNodeEvent() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}
