/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .networks.network.networktypes;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .tetopologytype.TeTopology;
import org.onosproject.yang.model.ModelObject;

/**
 * Represents the implementation of augmentedNwNetworkTypes.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultAugmentedNwNetworkTypes extends ModelObject implements AugmentedNwNetworkTypes {
    protected TeTopology teTopology;

    @Override
    public TeTopology teTopology() {
        return teTopology;
    }

    @Override
    public void teTopology(TeTopology teTopology) {
        this.teTopology = teTopology;
    }

    @Override
    public int hashCode() {
        return Objects.hash(teTopology);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultAugmentedNwNetworkTypes) {
            DefaultAugmentedNwNetworkTypes other = (DefaultAugmentedNwNetworkTypes) obj;
            return
                Objects.equals(teTopology, other.teTopology);
        }
        return false;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(getClass())
            .omitNullValues()
            .add("teTopology", teTopology)
            .toString();
    }


    /**
     * Creates an instance of defaultAugmentedNwNetworkTypes.
     */
    public DefaultAugmentedNwNetworkTypes() {
    }

}
