/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .telinkaugment.te;

import java.util.BitSet;
import java.util.List;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .TeOperStatus;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .informationsourceattributes.InformationSourceEnum;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .informationsourceattributes.InformationSourceState;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .telinkconfig.BundleStackLevel;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .telinkconfigattributes.TeLinkAttributes;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .telinkstatederived.AltInformationSources;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .telinkstatederived.Recovery;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .telinkstatederived.Underlay;

/**
 * Abstraction of an entity which represents the functionality of state.
 */
public interface State {

    /**
     * Identify the leaf of State.
     */
    public enum LeafIdentifier {
        /**
         * Represents operStatus.
         */
        OPERSTATUS(1),
        /**
         * Represents informationSource.
         */
        INFORMATIONSOURCE(2);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute operStatus.
     *
     * @return operStatus value of operStatus
     */
    TeOperStatus operStatus();

    /**
     * Returns the attribute informationSource.
     *
     * @return informationSource value of informationSource
     */
    InformationSourceEnum informationSource();

    /**
     * Returns the attribute teLinkTemplate.
     *
     * @return teLinkTemplate list of teLinkTemplate
     */
    List<Object> teLinkTemplate();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute altInformationSources.
     *
     * @return altInformationSources list of altInformationSources
     */
    List<AltInformationSources> altInformationSources();

    /**
     * Returns the attribute recovery.
     *
     * @return recovery value of recovery
     */
    Recovery recovery();

    /**
     * Returns the attribute underlay.
     *
     * @return underlay value of underlay
     */
    Underlay underlay();

    /**
     * Returns the attribute informationSourceState.
     *
     * @return informationSourceState value of informationSourceState
     */
    InformationSourceState informationSourceState();

    /**
     * Returns the attribute bundleStackLevel.
     *
     * @return bundleStackLevel value of bundleStackLevel
     */
    BundleStackLevel bundleStackLevel();

    /**
     * Returns the attribute teLinkAttributes.
     *
     * @return teLinkAttributes value of teLinkAttributes
     */
    TeLinkAttributes teLinkAttributes();

    /**
     * Sets the attribute operStatus.
     *
     * @param operStatus value of operStatus
     */
    void operStatus(TeOperStatus operStatus);

    /**
     * Sets the attribute informationSource.
     *
     * @param informationSource value of informationSource
     */
    void informationSource(InformationSourceEnum informationSource);

    /**
     * Sets the attribute teLinkTemplate.
     *
     * @param teLinkTemplate list of teLinkTemplate
     */
    void teLinkTemplate(List<Object> teLinkTemplate);

    /**
     * Sets the attribute altInformationSources.
     *
     * @param altInformationSources list of altInformationSources
     */
    void altInformationSources(List<AltInformationSources> altInformationSources);

    /**
     * Sets the attribute recovery.
     *
     * @param recovery value of recovery
     */
    void recovery(Recovery recovery);

    /**
     * Sets the attribute underlay.
     *
     * @param underlay value of underlay
     */
    void underlay(Underlay underlay);

    /**
     * Sets the attribute informationSourceState.
     *
     * @param informationSourceState value of informationSourceState
     */
    void informationSourceState(InformationSourceState informationSourceState);

    /**
     * Sets the attribute bundleStackLevel.
     *
     * @param bundleStackLevel value of bundleStackLevel
     */
    void bundleStackLevel(BundleStackLevel bundleStackLevel);

    /**
     * Sets the attribute teLinkAttributes.
     *
     * @param teLinkAttributes value of teLinkAttributes
     */
    void teLinkAttributes(TeLinkAttributes teLinkAttributes);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}
