/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .telinkconfigattributes.telinkattributes;

import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .telinkunderlayattributes.UnderlayBackupPath;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .telinkunderlayattributes.UnderlayPrimaryPath;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .telinkunderlayattributes.UnderlayTrailDes;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .telinkunderlayattributes.UnderlayTrailSrc;
import org.onosproject.yang.model.ModelObject;

/**
 * Represents the implementation of underlay.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultUnderlay extends ModelObject implements Underlay {
    protected int underlayProtectionType;
    protected BitSet valueLeafFlags = new BitSet();
    protected UnderlayPrimaryPath underlayPrimaryPath;
    protected List<UnderlayBackupPath> underlayBackupPath;
    protected UnderlayTrailSrc underlayTrailSrc;
    protected UnderlayTrailDes underlayTrailDes;

    @Override
    public int underlayProtectionType() {
        return underlayProtectionType;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public UnderlayPrimaryPath underlayPrimaryPath() {
        return underlayPrimaryPath;
    }

    @Override
    public List<UnderlayBackupPath> underlayBackupPath() {
        return underlayBackupPath;
    }

    @Override
    public UnderlayTrailSrc underlayTrailSrc() {
        return underlayTrailSrc;
    }

    @Override
    public UnderlayTrailDes underlayTrailDes() {
        return underlayTrailDes;
    }

    @Override
    public void underlayProtectionType(int underlayProtectionType) {
        valueLeafFlags.set(LeafIdentifier.UNDERLAYPROTECTIONTYPE.getLeafIndex());
        this.underlayProtectionType = underlayProtectionType;
    }

    @Override
    public void underlayPrimaryPath(UnderlayPrimaryPath underlayPrimaryPath) {
        this.underlayPrimaryPath = underlayPrimaryPath;
    }

    @Override
    public void underlayBackupPath(List<UnderlayBackupPath> underlayBackupPath) {
        this.underlayBackupPath = underlayBackupPath;
    }

    @Override
    public void underlayTrailSrc(UnderlayTrailSrc underlayTrailSrc) {
        this.underlayTrailSrc = underlayTrailSrc;
    }

    @Override
    public void underlayTrailDes(UnderlayTrailDes underlayTrailDes) {
        this.underlayTrailDes = underlayTrailDes;
    }

    @Override
    public int hashCode() {
         return Objects.hash(underlayProtectionType, valueLeafFlags, underlayPrimaryPath, underlayBackupPath,
                    underlayTrailSrc, underlayTrailDes);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultUnderlay) {
            DefaultUnderlay other = (DefaultUnderlay) obj;
            return
                Objects.equals(underlayProtectionType, other.underlayProtectionType) &&
                Objects.equals(valueLeafFlags, other.valueLeafFlags) &&
                Objects.equals(underlayPrimaryPath, other.underlayPrimaryPath) &&
                Objects.equals(underlayBackupPath, other.underlayBackupPath) &&
                Objects.equals(underlayTrailSrc, other.underlayTrailSrc) &&
                Objects.equals(underlayTrailDes, other.underlayTrailDes);
        }
        return false;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(getClass())
            .omitNullValues()
            .add("underlayProtectionType", underlayProtectionType)
            .add("valueLeafFlags", valueLeafFlags)
            .add("underlayPrimaryPath", underlayPrimaryPath)
            .add("underlayBackupPath", underlayBackupPath)
            .add("underlayTrailSrc", underlayTrailSrc)
            .add("underlayTrailDes", underlayTrailDes)
            .toString();
    }


    /**
     * Creates an instance of defaultUnderlay.
     */
    public DefaultUnderlay() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}
