/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .telinkinfoattributes;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .telinkinfoattributes.performancemetric.Measurement;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .telinkinfoattributes.performancemetric.Normality;
import org.onosproject.yang.model.ModelObject;

/**
 * Represents the implementation of performanceMetric.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultPerformanceMetric extends ModelObject implements PerformanceMetric {
    protected Measurement measurement;
    protected Normality normality;

    @Override
    public Measurement measurement() {
        return measurement;
    }

    @Override
    public Normality normality() {
        return normality;
    }

    @Override
    public void measurement(Measurement measurement) {
        this.measurement = measurement;
    }

    @Override
    public void normality(Normality normality) {
        this.normality = normality;
    }

    @Override
    public int hashCode() {
        return Objects.hash(measurement, normality);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultPerformanceMetric) {
            DefaultPerformanceMetric other = (DefaultPerformanceMetric) obj;
            return
                Objects.equals(measurement, other.measurement) &&
                Objects.equals(normality, other.normality);
        }
        return false;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(getClass())
            .omitNullValues()
            .add("measurement", measurement)
            .add("normality", normality)
            .toString();
    }


    /**
     * Creates an instance of defaultPerformanceMetric.
     */
    public DefaultPerformanceMetric() {
    }

}
