/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .telinkinfoattributes.interfaceswitchingcapability;

import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.util.BitSet;
import java.util.Objects;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .telinkinfoattributes.interfaceswitchingcapability.timedivisionmultiplexcapable.IndicationEnum;
import org.onosproject.yang.model.ModelObject;

/**
 * Represents the implementation of timeDivisionMultiplexCapable.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultTimeDivisionMultiplexCapable extends ModelObject implements TimeDivisionMultiplexCapable {
    protected BigDecimal minimumLspBandwidth;
    protected IndicationEnum indication;
    protected BitSet valueLeafFlags = new BitSet();

    @Override
    public BigDecimal minimumLspBandwidth() {
        return minimumLspBandwidth;
    }

    @Override
    public IndicationEnum indication() {
        return indication;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public void minimumLspBandwidth(BigDecimal minimumLspBandwidth) {
        valueLeafFlags.set(LeafIdentifier.MINIMUMLSPBANDWIDTH.getLeafIndex());
        this.minimumLspBandwidth = minimumLspBandwidth;
    }

    @Override
    public void indication(IndicationEnum indication) {
        valueLeafFlags.set(LeafIdentifier.INDICATION.getLeafIndex());
        this.indication = indication;
    }

    @Override
    public int hashCode() {
        return Objects.hash(minimumLspBandwidth, indication, valueLeafFlags);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultTimeDivisionMultiplexCapable) {
            DefaultTimeDivisionMultiplexCapable other = (DefaultTimeDivisionMultiplexCapable) obj;
            return
                Objects.equals(minimumLspBandwidth, other.minimumLspBandwidth) &&
                Objects.equals(indication, other.indication) &&
                Objects.equals(valueLeafFlags, other.valueLeafFlags);
        }
        return false;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(getClass())
            .omitNullValues()
            .add("minimumLspBandwidth", minimumLspBandwidth)
            .add("indication", indication)
            .add("valueLeafFlags", valueLeafFlags)
            .toString();
    }


    /**
     * Creates an instance of defaultTimeDivisionMultiplexCapable.
     */
    public DefaultTimeDivisionMultiplexCapable() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}
