/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .telinkinfoattributes.interfaceswitchingcapability;

import java.math.BigDecimal;
import java.util.BitSet;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .telinkinfoattributes.interfaceswitchingcapability.timedivisionmultiplexcapable.IndicationEnum;

/**
 * Abstraction of an entity which represents the functionality of timeDivisionMultiplexCapable.
 */
public interface TimeDivisionMultiplexCapable {

    /**
     * Identify the leaf of TimeDivisionMultiplexCapable.
     */
    public enum LeafIdentifier {
        /**
         * Represents minimumLspBandwidth.
         */
        MINIMUMLSPBANDWIDTH(1),
        /**
         * Represents indication.
         */
        INDICATION(2);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute minimumLspBandwidth.
     *
     * @return minimumLspBandwidth value of minimumLspBandwidth
     */
    BigDecimal minimumLspBandwidth();

    /**
     * Returns the attribute indication.
     *
     * @return indication value of indication
     */
    IndicationEnum indication();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Sets the attribute minimumLspBandwidth.
     *
     * @param minimumLspBandwidth value of minimumLspBandwidth
     */
    void minimumLspBandwidth(BigDecimal minimumLspBandwidth);

    /**
     * Sets the attribute indication.
     *
     * @param indication value of indication
     */
    void indication(IndicationEnum indication);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}
