/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .tenodeaugment;

import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .TeNodeId;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .tenodeaugment.te.Config;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .tenodeaugment.te.State;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .tenodeaugment.te.TunnelTerminationPoint;
import org.onosproject.yang.model.ModelObject;

/**
 * Represents the implementation of te.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultTe extends ModelObject implements Te {
    protected TeNodeId teNodeId;
    protected BitSet valueLeafFlags = new BitSet();
    protected Config config;
    protected State state;
    protected List<TunnelTerminationPoint> tunnelTerminationPoint;

    @Override
    public TeNodeId teNodeId() {
        return teNodeId;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public Config config() {
        return config;
    }

    @Override
    public State state() {
        return state;
    }

    @Override
    public List<TunnelTerminationPoint> tunnelTerminationPoint() {
        return tunnelTerminationPoint;
    }

    @Override
    public void teNodeId(TeNodeId teNodeId) {
        valueLeafFlags.set(LeafIdentifier.TENODEID.getLeafIndex());
        this.teNodeId = teNodeId;
    }

    @Override
    public void config(Config config) {
        this.config = config;
    }

    @Override
    public void state(State state) {
        this.state = state;
    }

    @Override
    public void tunnelTerminationPoint(List<TunnelTerminationPoint> tunnelTerminationPoint) {
        this.tunnelTerminationPoint = tunnelTerminationPoint;
    }

    @Override
    public int hashCode() {
        return Objects.hash(teNodeId, valueLeafFlags, config, state, tunnelTerminationPoint);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultTe) {
            DefaultTe other = (DefaultTe) obj;
            return
                Objects.equals(teNodeId, other.teNodeId) &&
                Objects.equals(valueLeafFlags, other.valueLeafFlags) &&
                Objects.equals(config, other.config) &&
                Objects.equals(state, other.state) &&
                Objects.equals(tunnelTerminationPoint, other.tunnelTerminationPoint);
        }
        return false;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(getClass())
            .omitNullValues()
            .add("teNodeId", teNodeId)
            .add("valueLeafFlags", valueLeafFlags)
            .add("config", config)
            .add("state", state)
            .add("tunnelTerminationPoint", tunnelTerminationPoint)
            .toString();
    }


    /**
     * Creates an instance of defaultTe.
     */
    public DefaultTe() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}
