/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .tenodeaugment.te;

import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .tenodeconfigattributes.TeNodeAttributes;
import org.onosproject.yang.model.ModelObject;

/**
 * Represents the implementation of config.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultConfig extends ModelObject implements Config {
    protected List<Object> teNodeTemplate;
    protected TeNodeAttributes teNodeAttributes;

    @Override
    public List<Object> teNodeTemplate() {
        return teNodeTemplate;
    }

    @Override
    public TeNodeAttributes teNodeAttributes() {
        return teNodeAttributes;
    }

    @Override
    public void teNodeTemplate(List<Object> teNodeTemplate) {
        this.teNodeTemplate = teNodeTemplate;
    }

    @Override
    public void teNodeAttributes(TeNodeAttributes teNodeAttributes) {
        this.teNodeAttributes = teNodeAttributes;
    }

    @Override
    public int hashCode() {
        return Objects.hash(teNodeTemplate, teNodeAttributes);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultConfig) {
            DefaultConfig other = (DefaultConfig) obj;
            return
                Objects.equals(teNodeTemplate, other.teNodeTemplate) &&
                Objects.equals(teNodeAttributes, other.teNodeAttributes);
        }
        return false;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(getClass())
            .omitNullValues()
            .add("teNodeTemplate", teNodeTemplate)
            .add("teNodeAttributes", teNodeAttributes)
            .toString();
    }


    /**
     * Creates an instance of defaultConfig.
     */
    public DefaultConfig() {
    }

}
