/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .tenodeconnectivitymatrixabs;

import java.util.BitSet;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .tenodeconnectivitymatrixabs.connectivitymatrix.From;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .tenodeconnectivitymatrixabs.connectivitymatrix.To;

/**
 * Abstraction of an entity which represents the functionality of connectivityMatrix.
 */
public interface ConnectivityMatrix {

    /**
     * Identify the leaf of ConnectivityMatrix.
     */
    public enum LeafIdentifier {
        /**
         * Represents id.
         */
        ID(1),
        /**
         * Represents isAllowed.
         */
        ISALLOWED(2);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute id.
     *
     * @return id value of id
     */
    long id();

    /**
     * Returns the attribute isAllowed.
     *
     * @return isAllowed value of isAllowed
     */
    boolean isAllowed();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute from.
     *
     * @return from value of from
     */
    From from();

    /**
     * Returns the attribute to.
     *
     * @return to value of to
     */
    To to();

    /**
     * Sets the attribute id.
     *
     * @param id value of id
     */
    void id(long id);

    /**
     * Sets the attribute isAllowed.
     *
     * @param isAllowed value of isAllowed
     */
    void isAllowed(boolean isAllowed);

    /**
     * Sets the attribute from.
     *
     * @param from value of from
     */
    void from(From from);

    /**
     * Sets the attribute to.
     *
     * @param to value of to
     */
    void to(To to);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}
