/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .tetopologiesaugment.te;

import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .tetopologiesaugment.te.templates.LinkTemplate;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .tetopologiesaugment.te.templates.NodeTemplate;
import org.onosproject.yang.model.ModelObject;

/**
 * Represents the implementation of templates.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultTemplates extends ModelObject implements Templates {
    protected List<NodeTemplate> nodeTemplate;
    protected List<LinkTemplate> linkTemplate;

    @Override
    public List<NodeTemplate> nodeTemplate() {
        return nodeTemplate;
    }

    @Override
    public List<LinkTemplate> linkTemplate() {
        return linkTemplate;
    }

    @Override
    public void nodeTemplate(List<NodeTemplate> nodeTemplate) {
        this.nodeTemplate = nodeTemplate;
    }

    @Override
    public void linkTemplate(List<LinkTemplate> linkTemplate) {
        this.linkTemplate = linkTemplate;
    }

    @Override
    public int hashCode() {
        return Objects.hash(nodeTemplate, linkTemplate);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultTemplates) {
            DefaultTemplates other = (DefaultTemplates) obj;
            return
                Objects.equals(nodeTemplate, other.nodeTemplate) &&
                Objects.equals(linkTemplate, other.linkTemplate);
        }
        return false;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(getClass())
            .omitNullValues()
            .add("nodeTemplate", nodeTemplate)
            .add("linkTemplate", linkTemplate)
            .toString();
    }


    /**
     * Creates an instance of defaultTemplates.
     */
    public DefaultTemplates() {
    }

}
