/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.types.rev20160320.yrtietftetypes
            .explicitroutesubobject.type;

import java.util.BitSet;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.inet.types.rev20130715.yrtietfinettypes
            .IpAddress;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.types.rev20160320.yrtietftetypes
            .explicitroutesubobject.Type;

/**
 * Abstraction of an entity which represents the functionality of unnumberedLink.
 */
public interface UnnumberedLink extends Type  {

    /**
     * Identify the leaf of UnnumberedLink.
     */
    public enum LeafIdentifier {
        /**
         * Represents routerId.
         */
        ROUTERID(1),
        /**
         * Represents interfaceId.
         */
        INTERFACEID(2);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute routerId.
     *
     * @return routerId value of routerId
     */
    IpAddress routerId();

    /**
     * Returns the attribute interfaceId.
     *
     * @return interfaceId value of interfaceId
     */
    long interfaceId();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Sets the attribute routerId.
     *
     * @param routerId value of routerId
     */
    void routerId(IpAddress routerId);

    /**
     * Sets the attribute interfaceId.
     *
     * @param interfaceId value of interfaceId
     */
    void interfaceId(long interfaceId);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}
