/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.types.rev20160320.yrtietftetypes
            .tunnelpathsrlgs.tunnelpathsrlgs.style;

import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.types.rev20160320.yrtietftetypes
            .tunnelpathsrlgs.tunnelpathsrlgs.Style;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.types.rev20160320.yrtietftetypes
            .tunnelpathsrlgs.tunnelpathsrlgs.style.named.Constraints;
import org.onosproject.yang.model.ModelObject;

/**
 * Represents the implementation of named.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultNamed extends ModelObject implements Named {
    protected List<Constraints> constraints;

    @Override
    public List<Constraints> constraints() {
        return constraints;
    }

    @Override
    public void constraints(List<Constraints> constraints) {
        this.constraints = constraints;
    }

    @Override
    public int hashCode() {
        return Objects.hash(constraints);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultNamed) {
            DefaultNamed other = (DefaultNamed) obj;
            return
                Objects.equals(constraints, other.constraints);
        }
        return false;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(getClass())
            .omitNullValues()
            .add("constraints", constraints)
            .toString();
    }


    /**
     * Creates an instance of defaultNamed.
     */
    public DefaultNamed() {
    }

}
