/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.types.rev20160320.yrtietftetypes
            .tunnelpathsrlgs.tunnelpathsrlgs.style;

import java.util.BitSet;
import java.util.List;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.types.rev20160320.yrtietftetypes
            .RouteExcludeSrlg;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.types.rev20160320.yrtietftetypes.Srlg;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.types.rev20160320.yrtietftetypes
            .tunnelpathsrlgs.tunnelpathsrlgs.Style;

/**
 * Abstraction of an entity which represents the functionality of values.
 */
public interface Values extends Style  {

    /**
     * Identify the leaf of Values.
     */
    public enum LeafIdentifier {
        /**
         * Represents usage.
         */
        USAGE(1);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute usage.
     *
     * @return usage value of usage
     */
    Class<? extends RouteExcludeSrlg> usage();

    /**
     * Returns the attribute values.
     *
     * @return values list of values
     */
    List<Srlg> values();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Sets the attribute usage.
     *
     * @param usage value of usage
     */
    void usage(Class<? extends RouteExcludeSrlg> usage);

    /**
     * Sets the attribute values.
     *
     * @param values list of values
     */
    void values(List<Srlg> values);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}
