/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrt.food.rev20160624.food;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.onosproject.yang.gen.v1.yrt.food.rev20160624.food.food.Snack;
import org.onosproject.yang.model.ModelObject;

/**
 * Represents the implementation of food.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultFood extends ModelObject implements Food {
    protected Snack snack;

    @Override
    public Snack snack() {
        return snack;
    }

    @Override
    public void snack(Snack snack) {
        this.snack = snack;
    }

    @Override
    public int hashCode() {
        return Objects.hash(snack);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultFood) {
            DefaultFood other = (DefaultFood) obj;
            return
                Objects.equals(snack, other.snack);
        }
        return false;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(getClass())
            .omitNullValues()
            .add("snack", snack)
            .toString();
    }


    /**
     * Creates an instance of defaultFood.
     */
    public DefaultFood() {
    }

}
