/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.runtime.app;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Test;
import org.onosproject.yang.model.NodeKey;
import org.onosproject.yang.runtime.api.CompositeData;
import org.onosproject.yang.runtime.api.CompositeStream;
import org.onosproject.yang.runtime.api.YangRuntimeService;
import org.onosproject.yang.runtime.api.YangSerializer;
import org.onosproject.yang.runtime.api.YangSerializerRegistry;
import org.onosproject.yang.runtime.app.DefaultYangRuntimeHandler;
import org.onosproject.yang.runtime.app.DefaultYangSerializerRegistry;
import org.onosproject.yang.runtime.app.TestSerializer;

public class RuntimeHandlerTest {
    private DefaultYangSerializerRegistry registry = new DefaultYangSerializerRegistry();
    private YangRuntimeService s = new DefaultYangRuntimeHandler((YangSerializerRegistry)this.registry, null);

    private void register(String df) {
        TestSerializer s = new TestSerializer(df);
        this.registry.registerSerializer((YangSerializer)s);
    }

    @Test
    public void validateRuntimeHandler() {
        this.register("XML");
        CompositeData dd = this.s.decode(null, "XML");
        MatcherAssert.assertThat((Object)"TestStream", (Matcher)Is.is((Object)((NodeKey)dd.resourceData().resourceId().nodeKeys().get(0)).schemaId().name()));
        CompositeStream cs = this.s.encode(null, "XML");
        MatcherAssert.assertThat((Object)"TestStream", (Matcher)Is.is((Object)cs.resourceId()));
    }

    @Test(expected=RuntimeException.class)
    public void validateRuntimeHandlerError() throws RuntimeException {
        this.register("XML");
        CompositeData dd = this.s.decode(null, "JSON");
        MatcherAssert.assertThat((Object)"TestStream", (Matcher)Is.is((Object)((NodeKey)dd.resourceData().resourceId().nodeKeys().get(0)).schemaId().name()));
    }
}

