/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.runtime.app;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Test;
import org.onosproject.yang.runtime.api.YangSerializer;
import org.onosproject.yang.runtime.app.DefaultYangSerializerRegistry;
import org.onosproject.yang.runtime.app.TestSerializer;

public class SerializerRegistryTest {
    public static final String XML = "XML";
    public static final String JSON = "JSON";
    private DefaultYangSerializerRegistry registry = new DefaultYangSerializerRegistry();

    private YangSerializer register(String df) {
        TestSerializer s = new TestSerializer(df);
        this.registry.registerSerializer((YangSerializer)s);
        return s;
    }

    @Test(expected=IllegalArgumentException.class)
    public void validatesSchemaRegistry() throws IllegalArgumentException {
        YangSerializer xml = this.register(XML);
        MatcherAssert.assertThat((Object)true, (Matcher)Is.is((Object)this.registry.getSerializers().contains(xml)));
        MatcherAssert.assertThat((Object)xml, (Matcher)Is.is((Object)this.registry.getSerializer(XML)));
        MatcherAssert.assertThat((Object)true, (Matcher)Is.is((Object)this.registry.getSerializers().contains(xml)));
        YangSerializer json = this.register(JSON);
        MatcherAssert.assertThat((Object)true, (Matcher)Is.is((Object)this.registry.getSerializers().contains(json)));
        MatcherAssert.assertThat((Object)json, (Matcher)Is.is((Object)this.registry.getSerializer(JSON)));
        MatcherAssert.assertThat((Object)true, (Matcher)Is.is((Object)this.registry.getSerializers().contains(json)));
        MatcherAssert.assertThat((Object)true, (Matcher)Is.is((Object)this.registry.getSerializers().contains(xml)));
        MatcherAssert.assertThat((Object)xml, (Matcher)Is.is((Object)this.registry.getSerializer(XML)));
        MatcherAssert.assertThat((Object)true, (Matcher)Is.is((Object)this.registry.getSerializers().contains(xml)));
        this.registry.unregisterSerializer(xml);
        MatcherAssert.assertThat((Object)true, (Matcher)Is.is((Object)this.registry.getSerializers().contains(json)));
        MatcherAssert.assertThat((Object)json, (Matcher)Is.is((Object)this.registry.getSerializer(JSON)));
        MatcherAssert.assertThat((Object)true, (Matcher)Is.is((Object)this.registry.getSerializers().contains(json)));
        MatcherAssert.assertThat((Object)false, (Matcher)Is.is((Object)this.registry.getSerializers().contains(xml)));
        MatcherAssert.assertThat((Object)false, (Matcher)Is.is((Object)this.registry.getSerializers().contains(xml)));
        this.registry.unregisterSerializer(xml);
        MatcherAssert.assertThat((Object)true, (Matcher)Is.is((Object)this.registry.getSerializers().contains(json)));
        MatcherAssert.assertThat((Object)json, (Matcher)Is.is((Object)this.registry.getSerializer(JSON)));
        MatcherAssert.assertThat((Object)false, (Matcher)Is.is((Object)this.registry.getSerializers().contains(xml)));
        YangSerializer xml2 = this.register(XML);
        MatcherAssert.assertThat((Object)true, (Matcher)Is.is((Object)this.registry.getSerializers().contains(xml2)));
        MatcherAssert.assertThat((Object)xml2, (Matcher)Is.is((Object)this.registry.getSerializer(XML)));
        MatcherAssert.assertThat((Object)true, (Matcher)Is.is((Object)this.registry.getSerializers().contains(json)));
        MatcherAssert.assertThat((Object)json, (Matcher)Is.is((Object)this.registry.getSerializer(JSON)));
        this.registry.unregisterSerializer(xml);
        this.registry.unregisterSerializer(json);
        MatcherAssert.assertThat((Object)false, (Matcher)Is.is((Object)this.registry.getSerializers().contains(xml2)));
        MatcherAssert.assertThat((Object)false, (Matcher)Is.is((Object)this.registry.getSerializers().contains(json)));
    }
}

