/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.runtime.app;

import org.junit.Test;
import org.onosproject.yang.compiler.datamodel.DefaultYangNamespace;
import org.onosproject.yang.compiler.datamodel.YangLeaf;
import org.onosproject.yang.compiler.datamodel.YangLeafList;
import org.onosproject.yang.compiler.datamodel.YangNamespace;
import org.onosproject.yang.compiler.datamodel.YangNode;
import org.onosproject.yang.compiler.datamodel.YangSchemaNodeIdentifier;
import org.onosproject.yang.compiler.datamodel.exceptions.DataModelException;
import org.onosproject.yang.model.DataNode;
import org.onosproject.yang.model.SchemaId;
import org.onosproject.yang.runtime.app.DefaultYangModelRegistry;
import org.onosproject.yang.runtime.app.TestUtils;
import org.onosproject.yang.runtime.app.TestYangSchemaNodeProvider;

public class TestCaseSchemaContext {
    private static TestYangSchemaNodeProvider schemaProvider = new TestYangSchemaNodeProvider();
    public static final String CASENS = "yrt:choice-case";

    @Test
    public void caseSchemaContTest() throws DataModelException {
        schemaProvider.processSchemaRegistry();
        DefaultYangModelRegistry registry = schemaProvider.registry();
        SchemaId id = new SchemaId("pretzel", CASENS);
        YangLeaf leaf = (YangLeaf)registry.getChildContext(id);
        TestUtils.checkLeafSchemaContext("pretzel", CASENS, "/", null, leaf);
        id = new SchemaId("light", CASENS);
        leaf = (YangLeaf)registry.getChildContext(id);
        TestUtils.checkLeafSchemaContext("light", CASENS, "/", null, leaf);
        id = new SchemaId("potato", CASENS);
        YangLeafList leafList = (YangLeafList)registry.getChildContext(id);
        TestUtils.checkLeafListSchemaContext("potato", CASENS, "/", null, leafList);
        id = new SchemaId("banana", CASENS);
        YangNode child = (YangNode)registry.getChildContext(id);
        TestUtils.checkSchemaContext("banana", CASENS, "/", null, DataNode.Type.MULTI_INSTANCE_NODE, child);
        id = new SchemaId("cold-drink", CASENS);
        child = (YangNode)registry.getChildContext(id);
        TestUtils.checkSchemaContext("cold-drink", CASENS, "/", null, DataNode.Type.SINGLE_INSTANCE_NODE, child);
        YangSchemaNodeIdentifier rId = new YangSchemaNodeIdentifier();
        rId.setName("flavor");
        rId.setNameSpace((YangNamespace)new DefaultYangNamespace(CASENS));
        leafList = (YangLeafList)child.getChildSchema(rId).getSchemaNode();
        TestUtils.checkLeafListSchemaContext("flavor", CASENS, "cold-drink", CASENS, leafList);
    }
}

