/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.runtime.app;

import org.junit.Test;
import org.onosproject.yang.compiler.datamodel.DefaultYangNamespace;
import org.onosproject.yang.compiler.datamodel.YangLeaf;
import org.onosproject.yang.compiler.datamodel.YangLeafList;
import org.onosproject.yang.compiler.datamodel.YangNamespace;
import org.onosproject.yang.compiler.datamodel.YangNode;
import org.onosproject.yang.compiler.datamodel.YangSchemaNode;
import org.onosproject.yang.compiler.datamodel.YangSchemaNodeIdentifier;
import org.onosproject.yang.compiler.datamodel.exceptions.DataModelException;
import org.onosproject.yang.model.DataNode;
import org.onosproject.yang.model.SchemaId;
import org.onosproject.yang.runtime.app.DefaultYangModelRegistry;
import org.onosproject.yang.runtime.app.TestUtils;
import org.onosproject.yang.runtime.app.TestYangSchemaNodeProvider;

public class TestLeafSchemaContext {
    private static TestYangSchemaNodeProvider schemaProvider = new TestYangSchemaNodeProvider();
    public static final String FOODNS = "yrt:food";

    @Test
    public void leafSchemaContTest() throws DataModelException {
        schemaProvider.processSchemaRegistry();
        DefaultYangModelRegistry registry = schemaProvider.registry();
        SchemaId id = new SchemaId("food", FOODNS);
        YangNode child = (YangNode)registry.getChildContext(id);
        TestUtils.checkSchemaContext("food", FOODNS, "/", null, DataNode.Type.SINGLE_INSTANCE_NODE, child);
        YangSchemaNodeIdentifier rId = new YangSchemaNodeIdentifier();
        rId.setName("pretzel");
        rId.setNameSpace((YangNamespace)new DefaultYangNamespace(FOODNS));
        YangSchemaNode leaf1 = child.getChildSchema(rId).getSchemaNode();
        TestUtils.checkLeafSchemaContext("pretzel", FOODNS, "food", FOODNS, (YangLeaf)leaf1);
        rId.setName("redbull");
        leaf1 = child.getChildSchema(rId).getSchemaNode();
        TestUtils.checkLeafSchemaContext("redbull", FOODNS, "food", FOODNS, (YangLeaf)leaf1);
        rId.setName("kingfisher");
        leaf1 = child.getChildSchema(rId).getSchemaNode();
        TestUtils.checkLeafSchemaContext("kingfisher", FOODNS, "food", FOODNS, (YangLeaf)leaf1);
        id = new SchemaId("bool", FOODNS);
        YangLeaf leaf = (YangLeaf)registry.getChildContext(id);
        TestUtils.checkLeafSchemaContext("bool", FOODNS, "/", null, leaf);
        id = new SchemaId("boolean", FOODNS);
        YangLeafList leafList = (YangLeafList)registry.getChildContext(id);
        TestUtils.checkLeafListSchemaContext("boolean", FOODNS, "/", null, leafList);
    }
}

