/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.runtime.app;

import java.util.List;
import org.junit.Test;
import org.onosproject.yang.compiler.datamodel.YangAugment;
import org.onosproject.yang.compiler.datamodel.YangAugmentableNode;
import org.onosproject.yang.compiler.datamodel.YangLeaf;
import org.onosproject.yang.compiler.datamodel.YangLeavesHolder;
import org.onosproject.yang.compiler.datamodel.YangNode;
import org.onosproject.yang.model.DataNode;
import org.onosproject.yang.model.SchemaId;
import org.onosproject.yang.runtime.app.DefaultYangModelRegistry;
import org.onosproject.yang.runtime.app.TestUtils;
import org.onosproject.yang.runtime.app.TestYangSchemaNodeProvider;

public class TestSchemaContext {
    private static TestYangSchemaNodeProvider schemaProvider = new TestYangSchemaNodeProvider();
    public static final String IETFNS = "urn:ietf:params:xml:ns:yang:yrt-ietf-network";
    public static final String TOPONS = "urn:ietf:params:xml:ns:yang:yrt-ietf-network-topology";

    @Test
    public void schemaContextBySchemaIdTest() {
        schemaProvider.processSchemaRegistry();
        DefaultYangModelRegistry registry = schemaProvider.registry();
        SchemaId id = new SchemaId("networks", IETFNS);
        YangNode child = (YangNode)registry.getChildContext(id);
        TestUtils.checkSchemaContext("networks", IETFNS, "/", null, DataNode.Type.SINGLE_INSTANCE_NODE, child);
        child = child.getChild();
        TestUtils.checkSchemaContext("network", IETFNS, "networks", IETFNS, DataNode.Type.MULTI_INSTANCE_NODE, child);
        List augInfo = ((YangAugmentableNode)child).getAugmentedInfoList();
        YangAugment augNode = (YangAugment)augInfo.get(0);
        TestUtils.checkSchemaContext("link", TOPONS, "network", IETFNS, DataNode.Type.MULTI_INSTANCE_NODE, augNode.getChild());
        List leafs = ((YangLeavesHolder)augNode.getChild()).getListOfLeaf();
        TestUtils.checkLeafSchemaContext("link-id", TOPONS, "link", TOPONS, (YangLeaf)leafs.get(0));
        child = child.getChild();
        TestUtils.checkSchemaContext("network-types", IETFNS, "network", IETFNS, DataNode.Type.SINGLE_INSTANCE_NODE, child);
        child = child.getParent();
        leafs = ((YangLeavesHolder)child).getListOfLeaf();
        for (YangLeaf leaf : leafs) {
            TestUtils.checkLeafSchemaContext("network-id", IETFNS, "network", IETFNS, leaf);
        }
        child = child.getParent().getNextSibling();
        TestUtils.checkSchemaContext("networks-state", IETFNS, "/", null, DataNode.Type.SINGLE_INSTANCE_NODE, child);
        child = child.getChild();
        TestUtils.checkSchemaContext("network", IETFNS, "networks-state", IETFNS, DataNode.Type.MULTI_INSTANCE_NODE, child);
        leafs = ((YangLeavesHolder)child).getListOfLeaf();
        TestUtils.checkLeafSchemaContext("network-ref", IETFNS, "network", IETFNS, (YangLeaf)leafs.get(1));
    }
}

