/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.runtime.app;

import org.junit.Assert;
import org.onosproject.yang.compiler.datamodel.YangLeaf;
import org.onosproject.yang.compiler.datamodel.YangLeafList;
import org.onosproject.yang.compiler.datamodel.YangNode;
import org.onosproject.yang.model.DataNode;
import org.onosproject.yang.model.SchemaId;

public final class TestUtils {
    private TestUtils() {
    }

    static void checkLeafSchemaContext(String name, String namespace, String pname, String pnamespace, YangLeaf child) {
        SchemaId id = child.getSchemaId();
        Assert.assertEquals((Object)id.name(), (Object)name);
        Assert.assertEquals((Object)id.namespace(), (Object)namespace);
        id = child.getParentContext().getSchemaId();
        Assert.assertEquals((Object)id.name(), (Object)pname);
        Assert.assertEquals((Object)id.namespace(), (Object)pnamespace);
        Assert.assertEquals((Object)child.getType(), (Object)DataNode.Type.SINGLE_INSTANCE_LEAF_VALUE_NODE);
    }

    static void checkLeafListSchemaContext(String name, String namespace, String pname, String pnamespace, YangLeafList child) {
        SchemaId id = child.getSchemaId();
        Assert.assertEquals((Object)id.name(), (Object)name);
        Assert.assertEquals((Object)id.namespace(), (Object)namespace);
        id = child.getParentContext().getSchemaId();
        Assert.assertEquals((Object)id.name(), (Object)pname);
        Assert.assertEquals((Object)id.namespace(), (Object)pnamespace);
        Assert.assertEquals((Object)child.getType(), (Object)DataNode.Type.MULTI_INSTANCE_LEAF_VALUE_NODE);
    }

    static void checkSchemaContext(String name, String namespace, String pname, String pnamespace, DataNode.Type type, YangNode child) {
        SchemaId id = child.getSchemaId();
        Assert.assertEquals((Object)id.name(), (Object)name);
        Assert.assertEquals((Object)id.namespace(), (Object)namespace);
        id = child.getParentContext().getSchemaId();
        Assert.assertEquals((Object)id.name(), (Object)pname);
        Assert.assertEquals((Object)id.namespace(), (Object)pnamespace);
        Assert.assertEquals((Object)child.getType(), (Object)type);
    }
}

