/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.runtime.app;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.onosproject.yang.YangModel;
import org.onosproject.yang.compiler.datamodel.YangNode;
import org.onosproject.yang.compiler.datamodel.YangSchemaNode;
import org.onosproject.yang.compiler.datamodel.utils.DataModelUtils;
import org.onosproject.yang.compiler.plugin.utils.YangApacheUtils;
import org.onosproject.yang.compiler.utils.io.impl.YangIoUtils;
import org.onosproject.yang.runtime.api.AppModuleInfo;
import org.onosproject.yang.runtime.api.ModelRegistrationParam;
import org.onosproject.yang.runtime.api.YangModelRegistry;
import org.onosproject.yang.runtime.app.DefaultAppModuleInfo;
import org.onosproject.yang.runtime.app.DefaultModelRegistrationParam;
import org.onosproject.yang.runtime.app.DefaultYangModelRegistry;
import org.onosproject.yang.runtime.utils.RuntimeHelper;

public class TestYangSchemaNodeProvider {
    private static final String FS = File.separator;
    private static final String PATH = System.getProperty("user.dir") + FS + "target" + FS + "classes" + FS;
    private static final String SER_FILE_PATH = "yang" + FS + "resources" + FS + "YangMetaData.ser";
    private static final String META_PATH = PATH + SER_FILE_PATH;
    private static final String TEMP_FOLDER_PATH = PATH + "Temp";
    private YangModelRegistry reg = new DefaultYangModelRegistry();
    private List<YangNode> nodes = new ArrayList<YangNode>();

    public void processSchemaRegistry() {
        try {
            Set appNode = DataModelUtils.deSerializeDataModel((String)META_PATH);
            this.nodes.addAll(appNode);
            ClassLoader classLoader = TestYangSchemaNodeProvider.class.getClassLoader();
            for (YangSchemaNode yangSchemaNode : this.nodes) {
                Class<?> cls;
                String appName = RuntimeHelper.getInterfaceClassName((YangSchemaNode)yangSchemaNode);
                try {
                    cls = classLoader.loadClass(appName);
                }
                catch (ClassNotFoundException e) {
                    continue;
                }
                DefaultModelRegistrationParam param = new DefaultModelRegistrationParam();
                YangModel model = YangApacheUtils.processYangModel((String)META_PATH, this.nodes);
                param.setYangModel(model);
                DefaultAppModuleInfo info = new DefaultAppModuleInfo();
                info.setModuleClass(cls);
                param.addAppModuleInfo(YangApacheUtils.processModuleId((YangNode)((YangNode)yangSchemaNode)), (AppModuleInfo)info);
                this.reg.registerModel((ModelRegistrationParam)param);
            }
            YangIoUtils.deleteDirectory((String)TEMP_FOLDER_PATH);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public DefaultYangModelRegistry registry() {
        return (DefaultYangModelRegistry)this.reg;
    }
}

