/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.network.rev20151208;

import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.network.rev20151208.yrtietfnetwork.Networks;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.network.rev20151208.yrtietfnetwork
            .NetworksState;

/**
 * Abstraction of an entity which represents the functionality of yrtIetfNetwork.
 */
public interface YrtIetfNetwork {

    /**
     * Returns the attribute networks.
     *
     * @return networks value of networks
     */
    Networks networks();

    /**
     * Returns the attribute networksState.
     *
     * @return networksState value of networksState
     */
    NetworksState networksState();

    /**
     * Sets the attribute networks.
     *
     * @param networks value of networks
     */
    void networks(Networks networks);

    /**
     * Sets the attribute networksState.
     *
     * @param networksState value of networksState
     */
    void networksState(NetworksState networksState);

}
