/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.network.rev20151208.yrtietfnetwork.networks
            .network;

import com.google.common.base.MoreObjects;
import java.util.BitSet;
import java.util.Objects;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.network.rev20151208.yrtietfnetwork.NetworkId;
import org.onosproject.yang.model.InnerModelObject;
import org.onosproject.yang.model.MultiInstanceObject;

/**
 * Represents the implementation of supportingNetwork.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultSupportingNetwork extends InnerModelObject 
        implements SupportingNetwork, MultiInstanceObject<SupportingNetworkKeys> {
    protected NetworkId networkRef;
    protected BitSet valueLeafFlags = new BitSet();

    @Override
    public NetworkId networkRef() {
        return networkRef;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public void networkRef(NetworkId networkRef) {
        valueLeafFlags.set(LeafIdentifier.NETWORKREF.getLeafIndex());
        this.networkRef = networkRef;
    }

    @Override
    public int hashCode() {
        return Objects.hash(networkRef, valueLeafFlags);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultSupportingNetwork) {
            DefaultSupportingNetwork other = (DefaultSupportingNetwork) obj;
            return
                Objects.equals(networkRef, other.networkRef) &&
                Objects.equals(valueLeafFlags, other.valueLeafFlags);
        }
        return false;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(getClass())
            .omitNullValues()
            .add("networkRef", networkRef)
            .add("valueLeafFlags", valueLeafFlags)
            .toString();
    }


    /**
     * Creates an instance of defaultSupportingNetwork.
     */
    public DefaultSupportingNetwork() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}
