/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.network.topology.rev20151208
            .yrtnetworktopology.networks.network.augmentedndnetwork.link;

import com.google.common.base.MoreObjects;
import java.util.BitSet;
import java.util.Objects;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.network.rev20151208.yrtietfnetwork.NodeId;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.network.topology.rev20151208
            .yrtnetworktopology.TpId;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of source.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultSource extends InnerModelObject implements Source {
    protected NodeId sourceNode;
    protected TpId sourceTp;
    protected BitSet valueLeafFlags = new BitSet();

    @Override
    public NodeId sourceNode() {
        return sourceNode;
    }

    @Override
    public TpId sourceTp() {
        return sourceTp;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public void sourceNode(NodeId sourceNode) {
        valueLeafFlags.set(LeafIdentifier.SOURCENODE.getLeafIndex());
        this.sourceNode = sourceNode;
    }

    @Override
    public void sourceTp(TpId sourceTp) {
        valueLeafFlags.set(LeafIdentifier.SOURCETP.getLeafIndex());
        this.sourceTp = sourceTp;
    }

    @Override
    public int hashCode() {
        return Objects.hash(sourceNode, sourceTp, valueLeafFlags);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultSource) {
            DefaultSource other = (DefaultSource) obj;
            return
                Objects.equals(sourceNode, other.sourceNode) &&
                Objects.equals(sourceTp, other.sourceTp) &&
                Objects.equals(valueLeafFlags, other.valueLeafFlags);
        }
        return false;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(getClass())
            .omitNullValues()
            .add("sourceNode", sourceNode)
            .add("sourceTp", sourceTp)
            .add("valueLeafFlags", valueLeafFlags)
            .toString();
    }


    /**
     * Creates an instance of defaultSource.
     */
    public DefaultSource() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}
