/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.schedule.rev20160301.yrtietfschedule
            .schedules;

import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.schedule.rev20160301.yrtietfschedule
            .schedules.schedules.Schedule;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of schedules.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultSchedules extends InnerModelObject implements Schedules {
    protected List<Schedule> schedule;

    @Override
    public List<Schedule> schedule() {
        return schedule;
    }

    @Override
    public void schedule(List<Schedule> schedule) {
        this.schedule = schedule;
    }

    @Override
    public int hashCode() {
        return Objects.hash(schedule);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultSchedules) {
            DefaultSchedules other = (DefaultSchedules) obj;
            return
                Objects.equals(schedule, other.schedule);
        }
        return false;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(getClass())
            .omitNullValues()
            .add("schedule", schedule)
            .toString();
    }


    /**
     * Creates an instance of defaultSchedules.
     */
    public DefaultSchedules() {
    }

}
