/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .telinkinfoattributes.interfaceswitchingcapability;

import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.util.BitSet;
import java.util.Objects;
import org.onosproject.yang.model.InnerModelObject;
import org.onosproject.yang.model.MultiInstanceObject;

/**
 * Represents the implementation of maxLspBandwidth.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultMaxLspBandwidth extends InnerModelObject 
        implements MaxLspBandwidth, MultiInstanceObject<MaxLspBandwidthKeys> {
    protected short priority;
    protected BigDecimal bandwidth;
    protected BitSet valueLeafFlags = new BitSet();

    @Override
    public short priority() {
        return priority;
    }

    @Override
    public BigDecimal bandwidth() {
        return bandwidth;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public void priority(short priority) {
        valueLeafFlags.set(LeafIdentifier.PRIORITY.getLeafIndex());
        this.priority = priority;
    }

    @Override
    public void bandwidth(BigDecimal bandwidth) {
        valueLeafFlags.set(LeafIdentifier.BANDWIDTH.getLeafIndex());
        this.bandwidth = bandwidth;
    }

    @Override
    public int hashCode() {
        return Objects.hash(priority, bandwidth, valueLeafFlags);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultMaxLspBandwidth) {
            DefaultMaxLspBandwidth other = (DefaultMaxLspBandwidth) obj;
            return
                Objects.equals(priority, other.priority) &&
                Objects.equals(bandwidth, other.bandwidth) &&
                Objects.equals(valueLeafFlags, other.valueLeafFlags);
        }
        return false;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(getClass())
            .omitNullValues()
            .add("priority", priority)
            .add("bandwidth", bandwidth)
            .add("valueLeafFlags", valueLeafFlags)
            .toString();
    }


    /**
     * Creates an instance of defaultMaxLspBandwidth.
     */
    public DefaultMaxLspBandwidth() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}
