/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .telinkinfoattributes.performancemetric;

import com.google.common.base.MoreObjects;
import java.util.BitSet;
import java.util.Objects;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .PerformanceMetricNormality;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of normality.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultNormality extends InnerModelObject implements Normality {
    protected PerformanceMetricNormality unidirectionalDelay;
    protected PerformanceMetricNormality unidirectionalMinDelay;
    protected PerformanceMetricNormality unidirectionalMaxDelay;
    protected PerformanceMetricNormality unidirectionalDelayVariation;
    protected PerformanceMetricNormality unidirectionalPacketLoss;
    protected PerformanceMetricNormality unidirectionalResidualBandwidth;
    protected PerformanceMetricNormality unidirectionalAvailableBandwidth;
    protected PerformanceMetricNormality unidirectionalUtilizedBandwidth;
    protected BitSet valueLeafFlags = new BitSet();

    @Override
    public PerformanceMetricNormality unidirectionalDelay() {
        return unidirectionalDelay;
    }

    @Override
    public PerformanceMetricNormality unidirectionalMinDelay() {
        return unidirectionalMinDelay;
    }

    @Override
    public PerformanceMetricNormality unidirectionalMaxDelay() {
        return unidirectionalMaxDelay;
    }

    @Override
    public PerformanceMetricNormality unidirectionalDelayVariation() {
        return unidirectionalDelayVariation;
    }

    @Override
    public PerformanceMetricNormality unidirectionalPacketLoss() {
        return unidirectionalPacketLoss;
    }

    @Override
    public PerformanceMetricNormality unidirectionalResidualBandwidth() {
        return unidirectionalResidualBandwidth;
    }

    @Override
    public PerformanceMetricNormality unidirectionalAvailableBandwidth() {
        return unidirectionalAvailableBandwidth;
    }

    @Override
    public PerformanceMetricNormality unidirectionalUtilizedBandwidth() {
        return unidirectionalUtilizedBandwidth;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public void unidirectionalDelay(PerformanceMetricNormality unidirectionalDelay) {
        valueLeafFlags.set(LeafIdentifier.UNIDIRECTIONALDELAY.getLeafIndex());
        this.unidirectionalDelay = unidirectionalDelay;
    }

    @Override
    public void unidirectionalMinDelay(PerformanceMetricNormality unidirectionalMinDelay) {
        valueLeafFlags.set(LeafIdentifier.UNIDIRECTIONALMINDELAY.getLeafIndex());
        this.unidirectionalMinDelay = unidirectionalMinDelay;
    }

    @Override
    public void unidirectionalMaxDelay(PerformanceMetricNormality unidirectionalMaxDelay) {
        valueLeafFlags.set(LeafIdentifier.UNIDIRECTIONALMAXDELAY.getLeafIndex());
        this.unidirectionalMaxDelay = unidirectionalMaxDelay;
    }

    @Override
    public void unidirectionalDelayVariation(PerformanceMetricNormality unidirectionalDelayVariation) {
        valueLeafFlags.set(LeafIdentifier.UNIDIRECTIONALDELAYVARIATION.getLeafIndex());
        this.unidirectionalDelayVariation = unidirectionalDelayVariation;
    }

    @Override
    public void unidirectionalPacketLoss(PerformanceMetricNormality unidirectionalPacketLoss) {
        valueLeafFlags.set(LeafIdentifier.UNIDIRECTIONALPACKETLOSS.getLeafIndex());
        this.unidirectionalPacketLoss = unidirectionalPacketLoss;
    }

    @Override
    public void unidirectionalResidualBandwidth(PerformanceMetricNormality unidirectionalResidualBandwidth) {
        valueLeafFlags.set(LeafIdentifier.UNIDIRECTIONALRESIDUALBANDWIDTH.getLeafIndex());
        this.unidirectionalResidualBandwidth = unidirectionalResidualBandwidth;
    }

    @Override
    public void unidirectionalAvailableBandwidth(PerformanceMetricNormality unidirectionalAvailableBandwidth) {
        valueLeafFlags.set(LeafIdentifier.UNIDIRECTIONALAVAILABLEBANDWIDTH.getLeafIndex());
        this.unidirectionalAvailableBandwidth = unidirectionalAvailableBandwidth;
    }

    @Override
    public void unidirectionalUtilizedBandwidth(PerformanceMetricNormality unidirectionalUtilizedBandwidth) {
        valueLeafFlags.set(LeafIdentifier.UNIDIRECTIONALUTILIZEDBANDWIDTH.getLeafIndex());
        this.unidirectionalUtilizedBandwidth = unidirectionalUtilizedBandwidth;
    }

    @Override
    public int hashCode() {
         return Objects.hash(unidirectionalDelay, unidirectionalMinDelay, unidirectionalMaxDelay,
                    unidirectionalDelayVariation, unidirectionalPacketLoss, unidirectionalResidualBandwidth,
                    unidirectionalAvailableBandwidth, unidirectionalUtilizedBandwidth, valueLeafFlags);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultNormality) {
            DefaultNormality other = (DefaultNormality) obj;
            return
                Objects.equals(unidirectionalDelay, other.unidirectionalDelay) &&
                Objects.equals(unidirectionalMinDelay, other.unidirectionalMinDelay) &&
                Objects.equals(unidirectionalMaxDelay, other.unidirectionalMaxDelay) &&
                Objects.equals(unidirectionalDelayVariation, other.unidirectionalDelayVariation) &&
                Objects.equals(unidirectionalPacketLoss, other.unidirectionalPacketLoss) &&
                Objects.equals(unidirectionalResidualBandwidth, other.unidirectionalResidualBandwidth) &&
                Objects.equals(unidirectionalAvailableBandwidth, other.unidirectionalAvailableBandwidth) &&
                Objects.equals(unidirectionalUtilizedBandwidth, other.unidirectionalUtilizedBandwidth) &&
                Objects.equals(valueLeafFlags, other.valueLeafFlags);
        }
        return false;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(getClass())
            .omitNullValues()
            .add("unidirectionalDelay", unidirectionalDelay)
            .add("unidirectionalMinDelay", unidirectionalMinDelay)
            .add("unidirectionalMaxDelay", unidirectionalMaxDelay)
            .add("unidirectionalDelayVariation", unidirectionalDelayVariation)
            .add("unidirectionalPacketLoss", unidirectionalPacketLoss)
            .add("unidirectionalResidualBandwidth", unidirectionalResidualBandwidth)
            .add("unidirectionalAvailableBandwidth", unidirectionalAvailableBandwidth)
            .add("unidirectionalUtilizedBandwidth", unidirectionalUtilizedBandwidth)
            .add("valueLeafFlags", valueLeafFlags)
            .toString();
    }


    /**
     * Creates an instance of defaultNormality.
     */
    public DefaultNormality() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}
