/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .tenodeaugment.te;

import java.util.BitSet;
import java.util.List;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .TeOperStatus;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .informationsourceattributes.InformationSourceEnum;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .informationsourceattributes.InformationSourceState;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .tenodeconfigattributes.TeNodeAttributes;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .tenodestatederived.AltInformationSources;

/**
 * Abstraction of an entity which represents the functionality of state.
 */
public interface State {

    /**
     * Identify the leaf of State.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents operStatus.
         */
        OPERSTATUS(1),
        /**
         * Represents isMultiAccessDr.
         */
        ISMULTIACCESSDR(2),
        /**
         * Represents informationSource.
         */
        INFORMATIONSOURCE(3),
        /**
         * Represents teNodeTemplate.
         */
        TENODETEMPLATE(4);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute operStatus.
     *
     * @return operStatus value of operStatus
     */
    TeOperStatus operStatus();

    /**
     * Returns the attribute isMultiAccessDr.
     *
     * @return isMultiAccessDr value of isMultiAccessDr
     */
    boolean isMultiAccessDr();

    /**
     * Returns the attribute informationSource.
     *
     * @return informationSource value of informationSource
     */
    InformationSourceEnum informationSource();

    /**
     * Returns the attribute teNodeTemplate.
     *
     * @return teNodeTemplate list of teNodeTemplate
     */
    List<Object> teNodeTemplate();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute altInformationSources.
     *
     * @return altInformationSources list of altInformationSources
     */
    List<AltInformationSources> altInformationSources();

    /**
     * Returns the attribute informationSourceState.
     *
     * @return informationSourceState value of informationSourceState
     */
    InformationSourceState informationSourceState();

    /**
     * Returns the attribute teNodeAttributes.
     *
     * @return teNodeAttributes value of teNodeAttributes
     */
    TeNodeAttributes teNodeAttributes();

    /**
     * Sets the attribute operStatus.
     *
     * @param operStatus value of operStatus
     */
    void operStatus(TeOperStatus operStatus);

    /**
     * Sets the attribute isMultiAccessDr.
     *
     * @param isMultiAccessDr value of isMultiAccessDr
     */
    void isMultiAccessDr(boolean isMultiAccessDr);

    /**
     * Sets the attribute informationSource.
     *
     * @param informationSource value of informationSource
     */
    void informationSource(InformationSourceEnum informationSource);

    /**
     * Sets the attribute teNodeTemplate.
     *
     * @param teNodeTemplate list of teNodeTemplate
     */
    void teNodeTemplate(List<Object> teNodeTemplate);

    /**
     * Sets the attribute altInformationSources.
     *
     * @param altInformationSources list of altInformationSources
     */
    void altInformationSources(List<AltInformationSources> altInformationSources);

    /**
     * Sets the attribute informationSourceState.
     *
     * @param informationSourceState value of informationSourceState
     */
    void informationSourceState(InformationSourceState informationSourceState);

    /**
     * Sets the attribute teNodeAttributes.
     *
     * @param teNodeAttributes value of teNodeAttributes
     */
    void teNodeAttributes(TeNodeAttributes teNodeAttributes);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}
