/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.yang.types.rev20130715.yrtietfyangtypes;

import java.util.Objects;

/**
 * Represents the implementation of counter32.
 */
public final class Counter32 {

    private long uint32;

    /**
     * Creates an instance of counter32.
     */
    private Counter32() {
    }

    /**
     * Creates an instance of uint32.
     *
     * @param uint32 value of uint32
     */
    public Counter32(long uint32) {
        this.uint32 = uint32;
    }

    /**
     * Returns the object of counter32 for type uint32.
     *
     * @param value value of counter32 for type uint32
     * @return counter32 for type uint32
     */
    public static Counter32 of(long value) {
        return new Counter32(value);
    }

    /**
     * Returns the attribute uint32.
     *
     * @return uint32 value of uint32
     */
    public long uint32() {
        return uint32;
    }
    /**
     * Sets the attribute uint32.
     *
     * @param uint32 value of uint32
     */
    public void uint32(long uint32) {
        this.uint32 = uint32;
    }

    @Override
    public int hashCode() {
        return Objects.hash(uint32);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Counter32) {
            Counter32 other = (Counter32) obj;
            return
                Objects.equals(uint32, other.uint32);
        }
        return false;
    }

    @Override
    public String toString() {
        return String.valueOf(uint32);
    }
    /**
     * Returns the object of counter32 fromString input String counter32.
     *
     * @param valInString value of input String
     * @return counter32
     */
    public static Counter32 fromString(String valInString) {
        try {
            long tmpVal = Long.parseLong(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
