/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrt.choice.yangautoprefixcase.rev20160624.choicecase.snack.sportsarena.bear.addon
            .snacks;

import java.util.BitSet;
import java.util.List;
import org.onosproject.yang.gen.v1.yrt.choice.yangautoprefixcase.rev20160624.choicecase.snack.sportsarena.bear.addon
            .Snacks;
import org.onosproject.yang.gen.v1.yrt.choice.yangautoprefixcase.rev20160624.choicecase.snack.sportsarena.bear.addon
            .snacks.chips.Banana;
import org.onosproject.yang.gen.v1.yrt.choice.yangautoprefixcase.rev20160624.choicecase.snack.sportsarena.bear.addon
            .snacks.chips.ColdDrink;

/**
 * Abstraction of an entity which represents the functionality of chips.
 */
public interface Chips extends Snacks  {

    /**
     * Identify the leaf of Chips.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents potato.
         */
        POTATO(1);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute potato.
     *
     * @return potato list of potato
     */
    List<Boolean> potato();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute banana.
     *
     * @return banana list of banana
     */
    List<Banana> banana();

    /**
     * Returns the attribute coldDrink.
     *
     * @return coldDrink value of coldDrink
     */
    ColdDrink coldDrink();

    /**
     * Sets the attribute potato.
     *
     * @param potato list of potato
     */
    void potato(List<Boolean> potato);

    /**
     * Sets the attribute banana.
     *
     * @param banana list of banana
     */
    void banana(List<Banana> banana);

    /**
     * Sets the attribute coldDrink.
     *
     * @param coldDrink value of coldDrink
     */
    void coldDrink(ColdDrink coldDrink);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}
