/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.inet.types.rev20130715.yrtietfinettypes.host;

import java.util.BitSet;
import java.util.Objects;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.inet.types.rev20130715.yrtietfinettypes.DomainName;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.inet.types.rev20130715.yrtietfinettypes.IpAddress;

public final class HostUnion {
    private IpAddress ipAddress;
    private DomainName domainName;
    private BitSet setValue = new BitSet();

    private HostUnion() {
    }

    public HostUnion(IpAddress ipAddress) {
        this.setValue.set(0);
        this.ipAddress = ipAddress;
    }

    public HostUnion(DomainName domainName) {
        this.setValue.set(1);
        this.domainName = domainName;
    }

    public static HostUnion of(IpAddress value) {
        return new HostUnion(value);
    }

    public static HostUnion of(DomainName value) {
        return new HostUnion(value);
    }

    public IpAddress ipAddress() {
        return this.ipAddress;
    }

    public DomainName domainName() {
        return this.domainName;
    }

    public void ipAddress(IpAddress ipAddress) {
        this.ipAddress = ipAddress;
    }

    public void domainName(DomainName domainName) {
        this.domainName = domainName;
    }

    public int hashCode() {
        return Objects.hash(this.ipAddress, this.domainName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof HostUnion) {
            HostUnion other = (HostUnion)obj;
            return Objects.equals(this.ipAddress, other.ipAddress) && Objects.equals(this.domainName, other.domainName);
        }
        return false;
    }

    public String toString() {
        if (this.setValue.get(0)) {
            return this.ipAddress.toString();
        }
        if (this.setValue.get(1)) {
            return this.domainName.toString();
        }
        return null;
    }

    public static HostUnion fromString(String valInString) {
        try {
            IpAddress tmpVal = IpAddress.fromString(valInString);
            return HostUnion.of(tmpVal);
        }
        catch (Exception tmpVal) {
            try {
                DomainName tmpVal2 = DomainName.fromString(valInString);
                return HostUnion.of(tmpVal2);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("not a valid input element");
            }
        }
    }
}

