/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.runtime.helperutils;

import java.util.Map;
import org.onosproject.yang.model.DataNode;
import org.onosproject.yang.model.InnerNode;
import org.onosproject.yang.runtime.helperutils.DataNodeListener;

public final class DefaultDataNodeWalker {
    private DefaultDataNodeWalker() {
    }

    public static void walk(DataNodeListener listener, DataNode node) {
        listener.enterDataNode(node);
        DefaultDataNodeWalker.walkChildNode(listener, node);
        listener.exitDataNode(node);
    }

    private static void walkChildNode(DataNodeListener listener, DataNode node) {
        if (node instanceof InnerNode) {
            Map childMap = ((InnerNode)node).childNodes();
            for (Map.Entry entry : childMap.entrySet()) {
                DataNode n = (DataNode)entry.getValue();
                listener.enterDataNode(n);
                if (n instanceof InnerNode) {
                    DefaultDataNodeWalker.walkChildNode(listener, n);
                }
                listener.exitDataNode(n);
            }
        }
    }
}

