/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.runtime.helperutils;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.onosproject.yang.compiler.datamodel.YangNode;
import org.onosproject.yang.compiler.datamodel.YangSchemaNode;
import org.onosproject.yang.compiler.utils.io.impl.YangIoUtils;
import org.onosproject.yang.model.YangModel;
import org.onosproject.yang.model.YangModule;
import org.onosproject.yang.runtime.helperutils.YangApacheUtils;

public final class RuntimeHelper {
    private RuntimeHelper() {
    }

    public static YangModel getModel(Class<?> aClass) {
        return YangApacheUtils.getYangModel(aClass);
    }

    public static Set<YangNode> getNodes(YangModel model) {
        HashSet<YangNode> nodes = new HashSet<YangNode>();
        Iterator it = model.getYangModules().iterator();
        if (it.hasNext()) {
            YangModule module = (YangModule)it.next();
            InputStream is = module.getMetadata();
            try {
                ObjectInputStream os = new ObjectInputStream(is);
                nodes.addAll((Set)os.readObject());
                os.close();
                is.close();
            }
            catch (IOException | ClassNotFoundException e) {
                throw new RuntimeException("failed to deserialize model" + e.getLocalizedMessage());
            }
        }
        return nodes;
    }

    public static String getInterfaceClassName(YangSchemaNode schemaNode) {
        return schemaNode.getJavaPackage() + "." + YangIoUtils.getCapitalCase((String)schemaNode.getJavaClassNameOrBuiltInType());
    }

    public static String getOpParamClassName(YangSchemaNode schemaNode) {
        return RuntimeHelper.getInterfaceClassName(schemaNode) + "OpParam";
    }

    public static String getServiceName(YangSchemaNode schemaNode) {
        return RuntimeHelper.getInterfaceClassName(schemaNode) + "Service";
    }

    public static String getDateInStringFormat(YangNode schemaNode) {
        return YangApacheUtils.getDateInStringFormat(schemaNode);
    }
}

