/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.runtime.impl;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.onosproject.yang.compiler.datamodel.SchemaDataNode;
import org.onosproject.yang.compiler.datamodel.YangChoice;
import org.onosproject.yang.compiler.datamodel.YangNode;
import org.onosproject.yang.compiler.datamodel.YangSchemaNode;
import org.onosproject.yang.compiler.datamodel.YangSchemaNodeIdentifier;
import org.onosproject.yang.compiler.datamodel.exceptions.DataModelException;
import org.onosproject.yang.compiler.datamodel.utils.DataModelUtils;
import org.onosproject.yang.model.DataNode;
import org.onosproject.yang.model.SchemaContext;
import org.onosproject.yang.model.SchemaId;
import org.onosproject.yang.model.SingleInstanceNodeContext;
import org.onosproject.yang.model.YangModel;
import org.onosproject.yang.model.YangModuleId;
import org.onosproject.yang.runtime.AppModuleInfo;
import org.onosproject.yang.runtime.ModelRegistrationParam;
import org.onosproject.yang.runtime.YangModelRegistry;
import org.onosproject.yang.runtime.helperutils.RuntimeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultYangModelRegistry
implements YangModelRegistry,
SingleInstanceNodeContext {
    private static final String AT = "@";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ConcurrentMap<String, ConcurrentMap<String, YangSchemaNode>> yangSchemaStore;
    private final ConcurrentMap<String, YangSchemaNode> interfaceNameKeyStore;
    private final ConcurrentMap<String, YangSchemaNode> opParamNameKeyStore;
    private final ConcurrentMap<String, YangSchemaNode> appNameKeyStore;
    private final ConcurrentMap<String, Class<?>> registerClassStore;
    private final ConcurrentMap<String, YangSchemaNode> nameSpaceSchemaStore;
    private final Set<YangModel> models = new LinkedHashSet<YangModel>();
    private SchemaId schemaId;

    public DefaultYangModelRegistry() {
        this.yangSchemaStore = new ConcurrentHashMap<String, ConcurrentMap<String, YangSchemaNode>>();
        this.interfaceNameKeyStore = new ConcurrentHashMap<String, YangSchemaNode>();
        this.opParamNameKeyStore = new ConcurrentHashMap<String, YangSchemaNode>();
        this.registerClassStore = new ConcurrentHashMap();
        this.appNameKeyStore = new ConcurrentHashMap<String, YangSchemaNode>();
        this.nameSpaceSchemaStore = new ConcurrentHashMap<String, YangSchemaNode>();
        this.schemaId = new SchemaId("/", null);
    }

    @Override
    public void registerModel(ModelRegistrationParam param) {
        Set<YangNode> curNodes;
        YangModel model = param.getYangModel();
        if (model != null) {
            curNodes = RuntimeHelper.getNodes(model);
            this.models.add(model);
            for (YangModuleId id : model.getYangModulesId()) {
                AppModuleInfo info = param.getAppModuleInfo(id);
                if (info == null) continue;
                Class<?> service = info.getModuleClass();
                String name = service.getName();
                if (this.verifyIfApplicationAlreadyRegistered(service)) continue;
                if (!this.registerClassStore.containsKey(name)) {
                    this.registerClassStore.put(name, service);
                }
                if (curNodes == null || curNodes.isEmpty()) continue;
                this.processRegistration(service, curNodes);
            }
        } else {
            throw new RuntimeException("model can not be null.");
        }
        this.updateChildContext(curNodes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterModel(ModelRegistrationParam param) {
        Class<DefaultYangModelRegistry> clazz = DefaultYangModelRegistry.class;
        synchronized (DefaultYangModelRegistry.class) {
            YangModel model = param.getYangModel();
            if (model != null) {
                for (YangModuleId id : model.getYangModulesId()) {
                    AppModuleInfo info = param.getAppModuleInfo(id);
                    Class<?> sClass = info.getModuleClass();
                    String serviceName = sClass.getName();
                    this.registerClassStore.remove(serviceName);
                    YangSchemaNode curNode = (YangSchemaNode)this.appNameKeyStore.get(serviceName);
                    if (curNode == null) {
                        curNode = (YangSchemaNode)this.interfaceNameKeyStore.get(serviceName);
                    }
                    if (curNode != null) {
                        this.removeSchemaNode(curNode);
                        this.interfaceNameKeyStore.remove(RuntimeHelper.getInterfaceClassName(curNode));
                        this.opParamNameKeyStore.remove(RuntimeHelper.getOpParamClassName(curNode));
                        this.appNameKeyStore.remove(serviceName);
                        this.nameSpaceSchemaStore.remove(curNode.getNameSpace().getModuleNamespace());
                        this.log.info(" service class {} of model {} is unregistered.", (Object)sClass.getSimpleName(), (Object)param);
                        continue;
                    }
                    this.log.error("Either {} service was not registered or already unregistered from model registry.", (Object)sClass.getSimpleName());
                }
            } else {
                throw new RuntimeException("model can not be null.");
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    public Set<YangModel> getModels() {
        return this.models;
    }

    public YangSchemaNode getForSchemaName(String schemaName) {
        return this.getForNameWithRev(schemaName);
    }

    public YangSchemaNode getForAppName(String appName) {
        YangSchemaNode node = (YangSchemaNode)this.appNameKeyStore.get(appName);
        if (node == null) {
            this.log.error("{} not found.", (Object)appName);
        }
        return node;
    }

    public YangSchemaNode getForInterfaceFileName(String name) {
        YangSchemaNode node = (YangSchemaNode)this.interfaceNameKeyStore.get(name);
        if (node == null) {
            this.log.error("{} not found.", (Object)name);
        }
        return node;
    }

    public YangSchemaNode getForOpPramFileName(String name) {
        YangSchemaNode node = (YangSchemaNode)this.opParamNameKeyStore.get(name);
        if (node == null) {
            this.log.error("{} not found.", (Object)name);
        }
        return node;
    }

    public YangSchemaNode getForNameSpace(String nameSpace) {
        YangSchemaNode node = (YangSchemaNode)this.nameSpaceSchemaStore.get(nameSpace);
        if (node == null) {
            this.log.error("node with {} namespace not found.", (Object)nameSpace);
        }
        return node;
    }

    public Class<?> getRegisteredClass(YangSchemaNode schemaNode) {
        Class regClass = null;
        if (schemaNode != null) {
            String interfaceName = RuntimeHelper.getInterfaceClassName(schemaNode);
            String serviceName = RuntimeHelper.getServiceName(schemaNode);
            regClass = (Class)this.registerClassStore.get(serviceName);
            if (regClass == null) {
                regClass = (Class)this.registerClassStore.get(interfaceName);
            }
        }
        this.log.error("{} node should not be null.");
        return regClass;
    }

    private void processRegistration(Class<?> service, Set<YangNode> nodes) {
        YangNode schemaNode = this.findNodeWhichShouldBeReg(service.getName(), nodes);
        if (schemaNode != null) {
            this.processApplicationContext((YangSchemaNode)schemaNode, service.getName());
        }
    }

    private YangNode findNodeWhichShouldBeReg(String name, Set<YangNode> nodes) {
        for (YangNode node : nodes) {
            if (!name.equals(RuntimeHelper.getServiceName((YangSchemaNode)node)) && !name.equals(RuntimeHelper.getInterfaceClassName((YangSchemaNode)node))) continue;
            return node;
        }
        return null;
    }

    private boolean verifyIfApplicationAlreadyRegistered(Class<?> appClass) {
        String appName = appClass.getName();
        return this.registerClassStore.containsKey(appName) || this.interfaceNameKeyStore.containsKey(appName);
    }

    private void processApplicationContext(YangSchemaNode appNode, String name) {
        try {
            if (appNode.isNotificationPresent()) {
                this.appNameKeyStore.put(name, appNode);
            }
        }
        catch (DataModelException e) {
            e.printStackTrace();
        }
        this.addToSchemaStore(appNode);
        this.interfaceNameKeyStore.put(RuntimeHelper.getInterfaceClassName(appNode), appNode);
        this.opParamNameKeyStore.put(RuntimeHelper.getOpParamClassName(appNode), appNode);
        this.nameSpaceSchemaStore.put(appNode.getNameSpace().getModuleNamespace(), appNode);
        this.log.info("successfully registered this application {}", (Object)name);
    }

    private YangSchemaNode getForNameWithRev(String name) {
        ConcurrentMap revMap;
        if (name.contains(AT)) {
            String[] revArray = name.split(AT);
            ConcurrentMap revMap2 = (ConcurrentMap)this.yangSchemaStore.get(revArray[0]);
            YangSchemaNode schemaNode = (YangSchemaNode)revMap2.get(name);
            if (schemaNode == null) {
                this.log.error("{} not found.", (Object)name);
            }
            return schemaNode;
        }
        if (this.yangSchemaStore.containsKey(name) && (revMap = (ConcurrentMap)this.yangSchemaStore.get(name)) != null && !revMap.isEmpty()) {
            YangSchemaNode node = (YangSchemaNode)revMap.get(name);
            if (node != null) {
                return node;
            }
            String revName = this.getLatestVersion(revMap);
            return (YangSchemaNode)revMap.get(revName);
        }
        this.log.error("{} not found.", (Object)name);
        return null;
    }

    private String getLatestVersion(ConcurrentMap<String, YangSchemaNode> revMap) {
        ArrayList keys = new ArrayList();
        for (Map.Entry entry : revMap.entrySet()) {
            keys.add(entry.getKey());
        }
        Collections.sort(keys);
        return (String)keys.get(keys.size() - 1);
    }

    private void addToSchemaStore(YangSchemaNode schemaNode) {
        String name;
        String date = RuntimeHelper.getDateInStringFormat((YangNode)schemaNode);
        String revName = name = schemaNode.getName();
        if (date != null) {
            revName = name + AT + date;
        }
        if (!this.yangSchemaStore.containsKey(name)) {
            ConcurrentHashMap<String, YangSchemaNode> revStore = new ConcurrentHashMap<String, YangSchemaNode>();
            revStore.put(revName, schemaNode);
            this.yangSchemaStore.put(name, revStore);
        } else {
            ((ConcurrentMap)this.yangSchemaStore.get(name)).put(revName, schemaNode);
        }
    }

    private void removeSchemaNode(YangSchemaNode removableNode) {
        ConcurrentMap revMap;
        String name;
        String revName = name = removableNode.getName();
        String date = RuntimeHelper.getDateInStringFormat((YangNode)removableNode);
        if (date != null) {
            revName = name + AT + date;
        }
        if ((revMap = (ConcurrentMap)this.yangSchemaStore.get(name)) != null && !revMap.isEmpty() && revMap.size() != 1) {
            revMap.remove(revName);
        } else {
            this.yangSchemaStore.remove(removableNode.getName());
        }
    }

    public SchemaContext getParentContext() {
        return null;
    }

    public DataNode.Type getType() {
        return DataNode.Type.SINGLE_INSTANCE_NODE;
    }

    public SchemaId getSchemaId() {
        return this.schemaId;
    }

    private void updateChildContext(Set<YangNode> nodes) {
        for (YangNode node : nodes) {
            node.setLeafRootContext((SchemaContext)this);
            for (YangNode child = node.getChild(); child != null; child = child.getNextSibling()) {
                if (child instanceof YangChoice) {
                    this.updateSchemaContextForChoiceChild(child);
                    continue;
                }
                if (!(child instanceof SchemaDataNode)) continue;
                child.setRootContext((SchemaContext)this);
            }
        }
    }

    private void updateContextForChoiceCase(YangNode child) {
        while (child != null) {
            if (child instanceof YangChoice) {
                this.updateSchemaContextForChoiceChild(child);
            } else if (child instanceof SchemaDataNode) {
                child.setRootContext((SchemaContext)this);
            }
            child = child.getNextSibling();
        }
    }

    private void updateSchemaContextForChoiceChild(YangNode curNode) {
        for (YangNode child = curNode.getChild(); child != null; child = child.getNextSibling()) {
            this.updateSchemaContextForCaseChild(child);
        }
    }

    private void updateSchemaContextForCaseChild(YangNode curNode) {
        curNode.setLeafRootContext((SchemaContext)this);
        YangNode child = curNode.getChild();
        this.updateContextForChoiceCase(child);
    }

    public SchemaContext getChildContext(SchemaId schemaId) {
        String namespace;
        YangSchemaNode node;
        Preconditions.checkNotNull((Object)schemaId);
        if (schemaId.namespace() == null) {
            this.log.error("node with {} namespace not found.", (Object)schemaId.namespace());
        }
        if ((node = this.getForNameSpace(namespace = schemaId.namespace())) == null) {
            node = this.getForSchemaName(schemaId.namespace());
        }
        YangSchemaNodeIdentifier id = DataModelUtils.getNodeIdFromSchemaId((SchemaId)schemaId, (String)namespace);
        try {
            if (node != null) {
                return node.getChildSchema(id).getSchemaNode();
            }
        }
        catch (DataModelException e) {
            this.log.error("failed to get child schema", (Throwable)e);
        }
        return null;
    }
}

