/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology;

import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .teoperstatus.TeOperStatusEnum;
import java.util.Objects;

/**
 * Represents the implementation of teOperStatus.
 */
public final class TeOperStatus {

    private TeOperStatusEnum enumeration;

    /**
     * Creates an instance of teOperStatus.
     */
    private TeOperStatus() {
    }

    /**
     * Creates an instance of enumeration.
     *
     * @param enumeration value of enumeration
     */
    public TeOperStatus(TeOperStatusEnum enumeration) {
        this.enumeration = enumeration;
    }

    /**
     * Returns the object of teOperStatus for type enumeration.
     *
     * @param value value of teOperStatus for type enumeration
     * @return teOperStatus for type enumeration
     */
    public static TeOperStatus of(TeOperStatusEnum value) {
        return new TeOperStatus(value);
    }

    /**
     * Returns the attribute enumeration.
     *
     * @return enumeration value of enumeration
     */
    public TeOperStatusEnum enumeration() {
        return enumeration;
    }
    /**
     * Sets the attribute enumeration.
     *
     * @param enumeration value of enumeration
     */
    public void enumeration(TeOperStatusEnum enumeration) {
        this.enumeration = enumeration;
    }

    @Override
    public int hashCode() {
        return Objects.hash(enumeration);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TeOperStatus) {
            TeOperStatus other = (TeOperStatus) obj;
            return
                Objects.equals(enumeration, other.enumeration);
        }
        return false;
    }

    @Override
    public String toString() {
        return enumeration.toString();
    }
    /**
     * Returns the object of teOperStatus fromString input String teOperStatus.
     *
     * @param valInString value of input String
     * @return teOperStatus
     */
    public static TeOperStatus fromString(String valInString) {
        try {
            TeOperStatusEnum tmpVal = TeOperStatusEnum.of(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
