/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .performancemetricthrottlecontainer;

import java.util.BitSet;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .performancemetricthrottlecontainer.performancemetricthrottle.ThresholdAcceleratedAdvertisement;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .performancemetricthrottlecontainer.performancemetricthrottle.ThresholdIn;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .performancemetricthrottlecontainer.performancemetricthrottle.ThresholdOut;

/**
 * Abstraction of an entity which represents the functionality of performanceMetricThrottle.
 */
public interface PerformanceMetricThrottle {

    /**
     * Identify the leaf of PerformanceMetricThrottle.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents unidirectionalDelayOffset.
         */
        UNIDIRECTIONALDELAYOFFSET(1),
        /**
         * Represents measureInterval.
         */
        MEASUREINTERVAL(2),
        /**
         * Represents advertisementInterval.
         */
        ADVERTISEMENTINTERVAL(3),
        /**
         * Represents suppressionInterval.
         */
        SUPPRESSIONINTERVAL(4);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute unidirectionalDelayOffset.
     *
     * @return unidirectionalDelayOffset value of unidirectionalDelayOffset
     */
    long unidirectionalDelayOffset();

    /**
     * Returns the attribute measureInterval.
     *
     * @return measureInterval value of measureInterval
     */
    long measureInterval();

    /**
     * Returns the attribute advertisementInterval.
     *
     * @return advertisementInterval value of advertisementInterval
     */
    long advertisementInterval();

    /**
     * Returns the attribute suppressionInterval.
     *
     * @return suppressionInterval value of suppressionInterval
     */
    long suppressionInterval();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute thresholdOut.
     *
     * @return thresholdOut value of thresholdOut
     */
    ThresholdOut thresholdOut();

    /**
     * Returns the attribute thresholdIn.
     *
     * @return thresholdIn value of thresholdIn
     */
    ThresholdIn thresholdIn();

    /**
     * Returns the attribute thresholdAcceleratedAdvertisement.
     *
     * @return thresholdAcceleratedAdvertisement value of thresholdAcceleratedAdvertisement
     */
    ThresholdAcceleratedAdvertisement thresholdAcceleratedAdvertisement();

    /**
     * Sets the attribute unidirectionalDelayOffset.
     *
     * @param unidirectionalDelayOffset value of unidirectionalDelayOffset
     */
    void unidirectionalDelayOffset(long unidirectionalDelayOffset);

    /**
     * Sets the attribute measureInterval.
     *
     * @param measureInterval value of measureInterval
     */
    void measureInterval(long measureInterval);

    /**
     * Sets the attribute advertisementInterval.
     *
     * @param advertisementInterval value of advertisementInterval
     */
    void advertisementInterval(long advertisementInterval);

    /**
     * Sets the attribute suppressionInterval.
     *
     * @param suppressionInterval value of suppressionInterval
     */
    void suppressionInterval(long suppressionInterval);

    /**
     * Sets the attribute thresholdOut.
     *
     * @param thresholdOut value of thresholdOut
     */
    void thresholdOut(ThresholdOut thresholdOut);

    /**
     * Sets the attribute thresholdIn.
     *
     * @param thresholdIn value of thresholdIn
     */
    void thresholdIn(ThresholdIn thresholdIn);

    /**
     * Sets the attribute thresholdAcceleratedAdvertisement.
     *
     * @param thresholdAcceleratedAdvertisement value of thresholdAcceleratedAdvertisement
     */
    void thresholdAcceleratedAdvertisement(ThresholdAcceleratedAdvertisement thresholdAcceleratedAdvertisement);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}
