/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .telinkinfoattributes;

import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .telinkinfoattributes.interfaceswitchingcapability.InterfaceAdjustmentCapability;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .telinkinfoattributes.interfaceswitchingcapability.MaxLspBandwidth;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .telinkinfoattributes.interfaceswitchingcapability.TimeDivisionMultiplexCapable;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.types.rev20160320.yrtietftetypes
            .LspEncodingTypes;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.types.rev20160320.yrtietftetypes
            .SwitchingCapabilities;
import org.onosproject.yang.model.InnerModelObject;
import org.onosproject.yang.model.MultiInstanceObject;

/**
 * Represents the implementation of interfaceSwitchingCapability.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultInterfaceSwitchingCapability extends InnerModelObject 
        implements InterfaceSwitchingCapability, MultiInstanceObject<InterfaceSwitchingCapabilityKeys> {
    protected Class<? extends SwitchingCapabilities> switchingCapability;
    protected Class<? extends LspEncodingTypes> encoding;
    protected BitSet valueLeafFlags = new BitSet();
    protected List<MaxLspBandwidth> maxLspBandwidth;
    protected TimeDivisionMultiplexCapable timeDivisionMultiplexCapable;
    protected List<InterfaceAdjustmentCapability> interfaceAdjustmentCapability;

    @Override
    public Class<? extends SwitchingCapabilities> switchingCapability() {
        return switchingCapability;
    }

    @Override
    public Class<? extends LspEncodingTypes> encoding() {
        return encoding;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public List<MaxLspBandwidth> maxLspBandwidth() {
        return maxLspBandwidth;
    }

    @Override
    public TimeDivisionMultiplexCapable timeDivisionMultiplexCapable() {
        return timeDivisionMultiplexCapable;
    }

    @Override
    public List<InterfaceAdjustmentCapability> interfaceAdjustmentCapability() {
        return interfaceAdjustmentCapability;
    }

    @Override
    public void switchingCapability(Class<? extends SwitchingCapabilities> switchingCapability) {
        valueLeafFlags.set(LeafIdentifier.SWITCHINGCAPABILITY.getLeafIndex());
        this.switchingCapability = switchingCapability;
    }

    @Override
    public void encoding(Class<? extends LspEncodingTypes> encoding) {
        valueLeafFlags.set(LeafIdentifier.ENCODING.getLeafIndex());
        this.encoding = encoding;
    }

    @Override
    public void maxLspBandwidth(List<MaxLspBandwidth> maxLspBandwidth) {
        this.maxLspBandwidth = maxLspBandwidth;
    }

    @Override
    public void timeDivisionMultiplexCapable(TimeDivisionMultiplexCapable timeDivisionMultiplexCapable) {
        this.timeDivisionMultiplexCapable = timeDivisionMultiplexCapable;
    }

    @Override
    public void interfaceAdjustmentCapability(List<InterfaceAdjustmentCapability> interfaceAdjustmentCapability) {
        this.interfaceAdjustmentCapability = interfaceAdjustmentCapability;
    }

    @Override
    public int hashCode() {
         return Objects.hash(switchingCapability, encoding, valueLeafFlags, maxLspBandwidth,
                    timeDivisionMultiplexCapable, interfaceAdjustmentCapability);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultInterfaceSwitchingCapability) {
            DefaultInterfaceSwitchingCapability other = (DefaultInterfaceSwitchingCapability) obj;
            return
                Objects.equals(switchingCapability, other.switchingCapability) &&
                Objects.equals(encoding, other.encoding) &&
                Objects.equals(valueLeafFlags, other.valueLeafFlags) &&
                Objects.equals(maxLspBandwidth, other.maxLspBandwidth) &&
                Objects.equals(timeDivisionMultiplexCapable, other.timeDivisionMultiplexCapable) &&
                Objects.equals(interfaceAdjustmentCapability, other.interfaceAdjustmentCapability);
        }
        return false;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(getClass())
            .omitNullValues()
            .add("switchingCapability", switchingCapability)
            .add("encoding", encoding)
            .add("valueLeafFlags", valueLeafFlags)
            .add("maxLspBandwidth", maxLspBandwidth)
            .add("timeDivisionMultiplexCapable", timeDivisionMultiplexCapable)
            .add("interfaceAdjustmentCapability", interfaceAdjustmentCapability)
            .toString();
    }


    /**
     * Creates an instance of defaultInterfaceSwitchingCapability.
     */
    public DefaultInterfaceSwitchingCapability() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}
