/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology.telinkinfoattributes;

import org.onosproject.yang.model.KeyInfo;
import java.util.Objects;

/**
 * Represents the implementation of unreservedBandwidth.
 */
public class UnreservedBandwidthKeys implements KeyInfo<DefaultUnreservedBandwidth> {
    protected short priority;
    /**
     * Returns the attribute priority.
     *
     * @return priority value of priority
     */
    public short priority() {
        return priority;
    }

    /**
     * Sets the value to attribute priority.
     *
     * @param priority value of priority
     */
    public void priority(short priority) {
        this.priority = priority;
    }


    @Override
    public int hashCode() {
        return Objects.hash(priority);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof UnreservedBandwidthKeys) {
            UnreservedBandwidthKeys other = (UnreservedBandwidthKeys) obj;
            return
                Objects.equals(priority, other.priority);
        }
        return false;
    }
}