/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .templateattributes;

/**
 * Represents ENUM data of referenceChangePolicyEnum.
 */
public enum ReferenceChangePolicyEnum {

    /**
     * Represents no-action.
     */
    NO_ACTION(0, "no-action"),

    /**
     * Represents not-allowed.
     */
    NOT_ALLOWED(1, "not-allowed"),

    /**
     * Represents cascade.
     */
    CASCADE(2, "cascade");

    private int referenceChangePolicyEnum;
    private String schemaName;

    /**
     * Creates an instance of referenceChangePolicyEnum.
     *
     * @param referenceChangePolicyEnum value of referenceChangePolicyEnum
     */
     ReferenceChangePolicyEnum(int referenceChangePolicyEnum, String schemaName) {
        this.referenceChangePolicyEnum = referenceChangePolicyEnum;
        this.schemaName = schemaName;
    }

    /**
     * Returns the object of referenceChangePolicyEnum for.
     *
     * @param value value of referenceChangePolicyEnum for
     * @return referenceChangePolicyEnum for
     */
    public static ReferenceChangePolicyEnum of(int value) {
        switch (value) {
            case 0:
                return ReferenceChangePolicyEnum.NO_ACTION;
            case 1:
                return ReferenceChangePolicyEnum.NOT_ALLOWED;
            case 2:
                return ReferenceChangePolicyEnum.CASCADE;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the object of referenceChangePolicyEnum for.
     *
     * @param value value of referenceChangePolicyEnum for
     * @return referenceChangePolicyEnum for
     */
    public static ReferenceChangePolicyEnum of(String value) {
        switch (value) {
            case "no-action":
                return ReferenceChangePolicyEnum.NO_ACTION;
            case "not-allowed":
                return ReferenceChangePolicyEnum.NOT_ALLOWED;
            case "cascade":
                return ReferenceChangePolicyEnum.CASCADE;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the attribute referenceChangePolicyEnum.
     *
     * @return referenceChangePolicyEnum value of referenceChangePolicyEnum
     */
    public int referenceChangePolicyEnum() {
        return referenceChangePolicyEnum;
    }


    @Override
    public String toString() {
        return schemaName;
    }
}
