/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .tenodeconnectivitymatrixabs.connectivitymatrix;

import java.util.BitSet;

/**
 * Abstraction of an entity which represents the functionality of from.
 */
public interface From {

    /**
     * Identify the leaf of From.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents tpRef.
         */
        TPREF(1),
        /**
         * Represents nodeRef.
         */
        NODEREF(2),
        /**
         * Represents networkRef.
         */
        NETWORKREF(3);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute tpRef.
     *
     * @return tpRef value of tpRef
     */
    Object tpRef();

    /**
     * Returns the attribute nodeRef.
     *
     * @return nodeRef value of nodeRef
     */
    Object nodeRef();

    /**
     * Returns the attribute networkRef.
     *
     * @return networkRef value of networkRef
     */
    Object networkRef();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Sets the attribute tpRef.
     *
     * @param tpRef value of tpRef
     */
    void tpRef(Object tpRef);

    /**
     * Sets the attribute nodeRef.
     *
     * @param nodeRef value of nodeRef
     */
    void nodeRef(Object nodeRef);

    /**
     * Sets the attribute networkRef.
     *
     * @param networkRef value of networkRef
     */
    void networkRef(Object networkRef);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}
